/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.net.Proxy;
import java.util.Arrays;
import java.util.function.LongPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.events.request.BatchProfileByUsernameRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.request.uuid.BatchProfileByUsernameRequest;
import pro.gravit.utils.helper.VerifyHelper;

public class YggdrasilGameProfileRepository
implements GameProfileRepository {
    private static final long BUSY_WAIT_MS = VerifyHelper.verifyLong((long)Long.parseLong(System.getProperty("launcher.com.mojang.authlib.busyWait", Long.toString(100L))), (LongPredicate)VerifyHelper.L_NOT_NEGATIVE, (String)"launcher.com.mojang.authlib.busyWait can't be < 0");
    private static final long ERROR_BUSY_WAIT_MS = VerifyHelper.verifyLong((long)Long.parseLong(System.getProperty("launcher.com.mojang.authlib.errorBusyWait", Long.toString(500L))), (LongPredicate)VerifyHelper.L_NOT_NEGATIVE, (String)"launcher.com.mojang.authlib.errorBusyWait can't be < 0");
    private static final Logger logger = LogManager.getLogger(YggdrasilGameProfileRepository.class);

    public YggdrasilGameProfileRepository() {
        logger.debug("Patched GameProfileRepository created");
    }

    public YggdrasilGameProfileRepository(YggdrasilAuthenticationService service, Environment environment) {
        logger.debug("Patched GameProfileRepository created");
    }

    public YggdrasilGameProfileRepository(Proxy proxy, Environment environment) {
        logger.debug("Patched GameProfileRepository created");
    }

    private static void busyWait(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void findProfilesByNames(String[] usernames, ProfileLookupCallback callback) {
        int offset = 0;
        while (offset < usernames.length) {
            PlayerProfile[] sliceProfiles;
            String[] sliceUsernames = Arrays.copyOfRange(usernames, offset, Math.min(offset + 128, usernames.length));
            offset += 128;
            try {
                sliceProfiles = ((BatchProfileByUsernameRequestEvent)new BatchProfileByUsernameRequest((String[])sliceUsernames).request()).playerProfiles;
            }
            catch (Exception e) {
                for (String username : sliceUsernames) {
                    logger.warn("Couldn't find profile '{}': {}", (Object)username, (Object)e);
                    callback.onProfileLookupFailed(username, e);
                }
                YggdrasilGameProfileRepository.busyWait(ERROR_BUSY_WAIT_MS);
                continue;
            }
            int len = sliceProfiles.length;
            for (int i = 0; i < len; ++i) {
                PlayerProfile pp = sliceProfiles[i];
                if (pp == null) {
                    String username = sliceUsernames[i];
                    logger.warn("Couldn't find profile '{}'", (Object)username);
                    callback.onProfileLookupFailed(username, new ProfileNotFoundException("Server did not find the requested profile"));
                    continue;
                }
                logger.debug("Successfully looked up profile '{}'", (Object)pp.username);
                callback.onProfileLookupSucceeded(YggdrasilMinecraftSessionService.toGameProfile(pp));
            }
            YggdrasilGameProfileRepository.busyWait(BUSY_WAIT_MS);
        }
    }
}

