import os

# Путь к директории с PNG файлами
directory = r"C:\Users\kainr\Nextcloud\LoliLand\Textures\textures for import in game\window_blind"

# Имя выходного файла
output_file = "output.txt"

# Открываем выходной файл для записи
with open(output_file, "w") as file:
    # Проходим по всем файлам в директории
    for filename in os.listdir(directory):
        if filename.endswith(".png"):
            # Имя переменной в верхнем регистре с подчеркиваниями
            variable_name = filename[:-4].upper()

            # Имя параметра name в camelCase
            parts = filename[:-4].split('_')
            name_param = parts[0].lower() + ''.join(part.capitalize() for part in parts[1:])

            # Путь к текстуре
            
            # Записываем фрагмент кода в файл
            file.write(f'val {variable_name} = LoliBlockLianaBase(\n')
            file.write(f'    name = "{name_param}",\n')
            file.write(f'    textureFolder = "niiwork/shabby_wall",\n')
            file.write(f'    material = Material.rock,\n')
            file.write(f'    creativeTab = LoliCreativeTabNiiwork,\n')
            file.write(f').apply {{\n')
            file.write(f'    setHardness(1.5f)\n')
            file.write(f'    setStepSound(Block.soundTypeStone)\n')
            file.write(f'    setHarvestLevel("pickaxe", 0)\n')
            file.write(f'}}.addToList()\n\n')

print(f"Код успешно сгенерирован в {output_file}")
