/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util.mc;

import javax.annotation.concurrent.Immutable;
import net.minecraft.util.EnumFacing;
import software.bernie.geckolib.forge.util.mc.FacingAxis;
import software.bernie.geckolib.forge.util.mc.MathUtil;
import software.bernie.geckolib.forge.util.mc.Position;

@Immutable
public class Vec3i
implements Comparable<Vec3i> {
    public static final Vec3i ZERO = new Vec3i(0, 0, 0);
    private int x;
    private int y;
    private int z;

    public Vec3i(int p_123296_, int p_123297_, int p_123298_) {
        this.x = p_123296_;
        this.y = p_123297_;
        this.z = p_123298_;
    }

    public boolean equals(Object p_123327_) {
        if (this == p_123327_) {
            return true;
        }
        if (!(p_123327_ instanceof Vec3i)) {
            return false;
        }
        Vec3i vec3i = (Vec3i)p_123327_;
        if (this.getX() != vec3i.getX()) {
            return false;
        }
        if (this.getY() != vec3i.getY()) {
            return false;
        }
        return this.getZ() == vec3i.getZ();
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(Vec3i p_123330_) {
        if (this.getY() == p_123330_.getY()) {
            return this.getZ() == p_123330_.getZ() ? this.getX() - p_123330_.getX() : this.getZ() - p_123330_.getZ();
        }
        return this.getY() - p_123330_.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    protected Vec3i setX(int value) {
        this.x = value;
        return this;
    }

    protected Vec3i setY(int value) {
        this.y = value;
        return this;
    }

    protected Vec3i setZ(int value) {
        this.z = value;
        return this;
    }

    public Vec3i offset(int p_175593_, int p_175594_, int p_175595_) {
        return p_175593_ == 0 && p_175594_ == 0 && p_175595_ == 0 ? this : new Vec3i(this.getX() + p_175593_, this.getY() + p_175594_, this.getZ() + p_175595_);
    }

    public Vec3i offset(Vec3i p_175597_) {
        return this.offset(p_175597_.getX(), p_175597_.getY(), p_175597_.getZ());
    }

    public Vec3i subtract(Vec3i p_175596_) {
        return this.offset(-p_175596_.getX(), -p_175596_.getY(), -p_175596_.getZ());
    }

    public Vec3i multiply(int value) {
        if (value == 1) {
            return this;
        }
        return value == 0 ? ZERO : new Vec3i(this.getX() * value, this.getY() * value, this.getZ() * value);
    }

    public Vec3i above() {
        return this.above(1);
    }

    public Vec3i above(int value) {
        return this.relative(EnumFacing.UP, value);
    }

    public Vec3i below() {
        return this.below(1);
    }

    public Vec3i below(int value) {
        return this.relative(EnumFacing.DOWN, value);
    }

    public Vec3i north() {
        return this.north(1);
    }

    public Vec3i north(int value) {
        return this.relative(EnumFacing.NORTH, value);
    }

    public Vec3i south() {
        return this.south(1);
    }

    public Vec3i south(int value) {
        return this.relative(EnumFacing.SOUTH, value);
    }

    public Vec3i west() {
        return this.west(1);
    }

    public Vec3i west(int value) {
        return this.relative(EnumFacing.WEST, value);
    }

    public Vec3i east() {
        return this.east(1);
    }

    public Vec3i east(int p_175598_) {
        return this.relative(EnumFacing.EAST, p_175598_);
    }

    public Vec3i relative(EnumFacing facing) {
        return this.relative(facing, 1);
    }

    public Vec3i relative(EnumFacing facing, int value) {
        return value == 0 ? this : new Vec3i(this.getX() + facing.func_82601_c() * value, this.getY() + facing.func_96559_d() * value, this.getZ() + facing.func_82599_e() * value);
    }

    public Vec3i relative(FacingAxis p_175590_, int p_175591_) {
        if (p_175591_ == 0) {
            return this;
        }
        int i = p_175590_ == FacingAxis.X ? p_175591_ : 0;
        int j = p_175590_ == FacingAxis.Y ? p_175591_ : 0;
        int k = p_175590_ == FacingAxis.Z ? p_175591_ : 0;
        return new Vec3i(this.getX() + i, this.getY() + j, this.getZ() + k);
    }

    public Vec3i cross(Vec3i p_123325_) {
        return new Vec3i(this.getY() * p_123325_.getZ() - this.getZ() * p_123325_.getY(), this.getZ() * p_123325_.getX() - this.getX() * p_123325_.getZ(), this.getX() * p_123325_.getY() - this.getY() * p_123325_.getX());
    }

    public boolean closerThan(Vec3i p_123315_, double p_123316_) {
        return this.distSqr(p_123315_) < MathUtil.square(p_123316_);
    }

    public boolean closerToCenterThan(Position p_203196_, double p_203197_) {
        return this.distToCenterSqr(p_203196_) < MathUtil.square(p_203197_);
    }

    public double distSqr(Vec3i p_123332_) {
        return this.distToLowCornerSqr(p_123332_.getX(), p_123332_.getY(), p_123332_.getZ());
    }

    public double distToCenterSqr(Position p_203194_) {
        return this.distToCenterSqr(p_203194_.x(), p_203194_.y(), p_203194_.z());
    }

    public double distToCenterSqr(double p_203199_, double p_203200_, double p_203201_) {
        double d0 = (double)this.getX() + 0.5 - p_203199_;
        double d1 = (double)this.getY() + 0.5 - p_203200_;
        double d2 = (double)this.getZ() + 0.5 - p_203201_;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double distToLowCornerSqr(double p_203203_, double p_203204_, double p_203205_) {
        double d0 = (double)this.getX() - p_203203_;
        double d1 = (double)this.getY() - p_203204_;
        double d2 = (double)this.getZ() - p_203205_;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public int distManhattan(Vec3i p_123334_) {
        float f = Math.abs(p_123334_.getX() - this.getX());
        float f1 = Math.abs(p_123334_.getY() - this.getY());
        float f2 = Math.abs(p_123334_.getZ() - this.getZ());
        return (int)(f + f1 + f2);
    }

    public int get(FacingAxis p_123305_) {
        return p_123305_.choose(this.x, this.y, this.z);
    }

    public String toShortString() {
        return this.getX() + ", " + this.getY() + ", " + this.getZ();
    }
}

