/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util.mc;

import com.google.common.collect.Queues;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Deque;
import java.util.function.Consumer;
import software.bernie.geckolib.forge.util.mc.MathUtil;
import software.bernie.libs.joml.Matrix3f;
import software.bernie.libs.joml.Matrix4f;
import software.bernie.libs.joml.Quaternionf;

@SideOnly(value=Side.CLIENT)
public class PoseStack {
    private final Deque<Pose> poseStack = PoseStack.make(Queues.newArrayDeque(), value -> {
        Matrix4f matrix4f = new Matrix4f();
        Matrix3f matrix3f = new Matrix3f();
        value.add(new Pose(matrix4f, matrix3f));
    });

    public void translate(double x, double y, double z) {
        this.translate((float)x, (float)y, (float)z);
    }

    public void translate(float x, float y, float z) {
        Pose posestackPose = this.poseStack.getLast();
        posestackPose.pose.translate(x, y, z);
    }

    public void scale(float p_85842_, float p_85843_, float p_85844_) {
        Pose posestackPose = this.poseStack.getLast();
        posestackPose.pose.scale(p_85842_, p_85843_, p_85844_);
        if (p_85842_ == p_85843_ && p_85843_ == p_85844_) {
            if (p_85842_ > 0.0f) {
                return;
            }
            posestackPose.normal.scale(-1.0f);
        }
        float f = 1.0f / p_85842_;
        float f1 = 1.0f / p_85843_;
        float f2 = 1.0f / p_85844_;
        float f3 = MathUtil.fastInvCubeRoot(f * f1 * f2);
        posestackPose.normal.scale(f3 * f, f3 * f1, f3 * f2);
    }

    public void mulPose(Quaternionf quaternionf) {
        Pose posestackPose = this.poseStack.getLast();
        posestackPose.pose.rotate(quaternionf);
        posestackPose.normal.rotate(quaternionf);
    }

    public void rotateAround(Quaternionf quaternionf, float ox, float oy, float oz) {
        Pose posestackPose = this.poseStack.getLast();
        posestackPose.pose.rotateAround(quaternionf, ox, oy, oz);
        posestackPose.normal.rotate(quaternionf);
    }

    public void pushPose() {
        Pose posestackPose = this.poseStack.getLast();
        this.poseStack.addLast(new Pose(new Matrix4f(posestackPose.pose), new Matrix3f(posestackPose.normal)));
    }

    public void popPose() {
        this.poseStack.removeLast();
    }

    public Pose last() {
        return this.poseStack.getLast();
    }

    public boolean clear() {
        return this.poseStack.size() == 1;
    }

    public void setIdentity() {
        Pose posestackPose = this.poseStack.getLast();
        posestackPose.pose.identity();
        posestackPose.normal.identity();
    }

    public void mulPoseMatrix(Matrix4f p_254128_) {
        this.poseStack.getLast().pose.mul(p_254128_);
    }

    public static <T> T make(T value, Consumer<T> consumer) {
        consumer.accept(value);
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public static final class Pose {
        final Matrix4f pose;
        final Matrix3f normal;

        Pose(Matrix4f pose, Matrix3f normal) {
            this.pose = pose;
            this.normal = normal;
        }

        public Matrix4f pose() {
            return this.pose;
        }

        public Matrix3f normal() {
            return this.normal;
        }
    }
}

