/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util.mc;

import java.util.function.Consumer;
import software.bernie.libs.joml.Math;

public class MathUtil {
    public static final float DEG_TO_RAD = (float)java.lang.Math.PI / 180;
    public static final float HALF_PI = 1.5707964f;
    private static final float[] SIN = MathUtil.make(new float[65536], value -> {
        for (int i = 0; i < ((float[])value).length; ++i) {
            value[i] = (float)java.lang.Math.sin((double)i * java.lang.Math.PI * 2.0 / 65536.0);
        }
    });

    public static float invSqrt(float p_265060_) {
        return Math.invsqrt(p_265060_);
    }

    public static double invSqrt(double p_265088_) {
        return Math.invsqrt(p_265088_);
    }

    public static float rotLerp(float p_14190_, float p_14191_, float p_14192_) {
        return p_14191_ + p_14190_ * MathUtil.wrapDegrees(p_14192_ - p_14191_);
    }

    public static float wrapDegrees(float p_14178_) {
        float f = p_14178_ % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static float sin(float value) {
        return SIN[(int)(value * 10430.378f) & 0xFFFF];
    }

    public static float cos(float value) {
        return SIN[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float square(float value) {
        return value * value;
    }

    public static double square(double value) {
        return value * value;
    }

    public static float lerp(float p_14180_, float p_14181_, float p_14182_) {
        return p_14181_ + p_14180_ * (p_14182_ - p_14181_);
    }

    public static double lerp(double p_14140_, double p_14141_, double p_14142_) {
        return p_14141_ + p_14140_ * (p_14142_ - p_14141_);
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static float sqrt(float value) {
        return (float)java.lang.Math.sqrt(value);
    }

    public static float fastInvCubeRoot(float value) {
        int i = Float.floatToIntBits(value);
        i = 1419967116 - i / 3;
        float f = Float.intBitsToFloat(i);
        f = 0.6666667f * f + 1.0f / (3.0f * f * f * value);
        return 0.6666667f * f + 1.0f / (3.0f * f * f * value);
    }

    public static int clamp(int p_14046_, int p_14047_, int p_14048_) {
        return java.lang.Math.min(java.lang.Math.max(p_14046_, p_14047_), p_14048_);
    }

    public static float clamp(float p_14037_, float p_14038_, float p_14039_) {
        return p_14037_ < p_14038_ ? p_14038_ : java.lang.Math.min(p_14037_, p_14039_);
    }

    public static double clamp(double p_14009_, double p_14010_, double p_14011_) {
        return p_14009_ < p_14010_ ? p_14010_ : java.lang.Math.min(p_14009_, p_14011_);
    }

    public static <T> T make(T value, Consumer<T> consumer) {
        consumer.accept(value);
        return value;
    }

    public static boolean isMultipleOf(int pNumber, int pMultiple) {
        return pNumber % pMultiple == 0;
    }
}

