/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util.mc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Type;
import software.bernie.geckolib.forge.util.mc.ItemDisplayContext;
import software.bernie.geckolib.forge.util.mc.ItemTransform;

@SideOnly(value=Side.CLIENT)
public class ItemTransforms {
    public static final ItemTransforms NO_TRANSFORMS = new ItemTransforms();
    public final ItemTransform thirdPersonRightHand;
    public final ItemTransform firstPersonRightHand;
    public final ItemTransform head;
    public final ItemTransform gui;
    public final ItemTransform ground;
    public final ItemTransform fixed;
    public final ImmutableMap<ItemDisplayContext, ItemTransform> moddedTransforms;

    private ItemTransforms() {
        this(ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM, ItemTransform.NO_TRANSFORM);
    }

    public ItemTransforms(ItemTransforms p_111807_) {
        this.thirdPersonRightHand = p_111807_.thirdPersonRightHand;
        this.firstPersonRightHand = p_111807_.firstPersonRightHand;
        this.head = p_111807_.head;
        this.gui = p_111807_.gui;
        this.ground = p_111807_.ground;
        this.fixed = p_111807_.fixed;
        this.moddedTransforms = p_111807_.moddedTransforms;
    }

    public ItemTransforms(ItemTransform p_111799_, ItemTransform p_111801_, ItemTransform p_111802_, ItemTransform p_111803_, ItemTransform p_111804_, ItemTransform p_111805_) {
        this(p_111799_, p_111801_, p_111802_, p_111803_, p_111804_, p_111805_, (ImmutableMap<ItemDisplayContext, ItemTransform>)ImmutableMap.of());
    }

    public ItemTransforms(ItemTransform p_111799_, ItemTransform p_111801_, ItemTransform p_111802_, ItemTransform p_111803_, ItemTransform p_111804_, ItemTransform p_111805_, ImmutableMap<ItemDisplayContext, ItemTransform> moddedTransforms) {
        this.thirdPersonRightHand = p_111799_;
        this.firstPersonRightHand = p_111801_;
        this.head = p_111802_;
        this.gui = p_111803_;
        this.ground = p_111804_;
        this.fixed = p_111805_;
        this.moddedTransforms = moddedTransforms;
    }

    public ItemTransform getTransform(ItemDisplayContext p_270619_) {
        ItemTransform itemtransform;
        switch (p_270619_) {
            case THIRD_PERSON_RIGHT_HAND: {
                itemtransform = this.thirdPersonRightHand;
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                itemtransform = this.firstPersonRightHand;
                break;
            }
            case HEAD: {
                itemtransform = this.head;
                break;
            }
            case GUI: {
                itemtransform = this.gui;
                break;
            }
            case GROUND: {
                itemtransform = this.ground;
                break;
            }
            case FIXED: {
                itemtransform = this.fixed;
                break;
            }
            default: {
                return (ItemTransform)this.moddedTransforms.getOrDefault((Object)p_270619_, (Object)ItemTransform.NO_TRANSFORM);
            }
        }
        return itemtransform;
    }

    public boolean hasTransform(ItemDisplayContext context) {
        return this.getTransform(context) != ItemTransform.NO_TRANSFORM;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<ItemTransforms> {
        public ItemTransforms deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = jsonElement.getAsJsonObject();
            if (jsonobject.has("display")) {
                jsonobject = jsonobject.getAsJsonObject("display");
            }
            ItemTransform itemtransform = this.getTransform(context, jsonobject, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
            ItemTransform itemtransform2 = this.getTransform(context, jsonobject, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
            ItemTransform itemtransform4 = this.getTransform(context, jsonobject, ItemDisplayContext.HEAD);
            ItemTransform itemtransform5 = this.getTransform(context, jsonobject, ItemDisplayContext.GUI);
            ItemTransform itemtransform6 = this.getTransform(context, jsonobject, ItemDisplayContext.GROUND);
            ItemTransform itemtransform7 = this.getTransform(context, jsonobject, ItemDisplayContext.FIXED);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            return new ItemTransforms(itemtransform, itemtransform2, itemtransform4, itemtransform5, itemtransform6, itemtransform7, (ImmutableMap<ItemDisplayContext, ItemTransform>)builder.build());
        }

        private ItemTransform getTransform(JsonDeserializationContext context, JsonObject jsonObject, ItemDisplayContext p_270100_) {
            String s = p_270100_.getSerializedName();
            return jsonObject.has(s) ? (ItemTransform)context.deserialize(jsonObject.get(s), ItemTransform.class) : ItemTransform.NO_TRANSFORM;
        }
    }
}

