/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util.mc;

import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraftforge.client.IItemRenderer;

public enum ItemDisplayContext {
    NONE(0, "none"),
    THIRD_PERSON_RIGHT_HAND(1, "thirdperson_righthand"),
    FIRST_PERSON_RIGHT_HAND(2, "firstperson_righthand"),
    HEAD(3, "head"),
    GUI(4, "gui"),
    GROUND(5, "ground"),
    FIXED(6, "fixed");

    private byte id;
    private final String name;

    private ItemDisplayContext(int id, String name) {
        this.name = name;
        this.id = (byte)id;
    }

    public String getSerializedName() {
        return this.name;
    }

    public byte getId() {
        return this.id;
    }

    public boolean firstPerson() {
        return this == FIRST_PERSON_RIGHT_HAND;
    }

    public static ItemDisplayContext transform(IItemRenderer.ItemRenderType type) {
        if (type != null) {
            switch (type) {
                case ENTITY: {
                    return RenderItem.field_82407_g ? FIXED : GROUND;
                }
                case INVENTORY: {
                    return GUI;
                }
                case EQUIPPED: {
                    return THIRD_PERSON_RIGHT_HAND;
                }
                case EQUIPPED_FIRST_PERSON: {
                    return FIRST_PERSON_RIGHT_HAND;
                }
            }
        }
        return NONE;
    }
}

