/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util.mc;

import software.bernie.geckolib.forge.util.mc.MathUtil;

public class FastColor {

    public static class ARGB32 {
        public static int alpha(int pPackedColor) {
            return pPackedColor >>> 24;
        }

        public static int red(int pPackedColor) {
            return pPackedColor >> 16 & 0xFF;
        }

        public static int green(int pPackedColor) {
            return pPackedColor >> 8 & 0xFF;
        }

        public static int blue(int pPackedColor) {
            return pPackedColor & 0xFF;
        }

        public static int color(int pAlpha, int pRed, int pGreen, int pBlue) {
            return pAlpha << 24 | pRed << 16 | pGreen << 8 | pBlue;
        }

        public static int multiply(int pPackedColourOne, int pPackedColorTwo) {
            return ARGB32.color(ARGB32.alpha(pPackedColourOne) * ARGB32.alpha(pPackedColorTwo) / 255, ARGB32.red(pPackedColourOne) * ARGB32.red(pPackedColorTwo) / 255, ARGB32.green(pPackedColourOne) * ARGB32.green(pPackedColorTwo) / 255, ARGB32.blue(pPackedColourOne) * ARGB32.blue(pPackedColorTwo) / 255);
        }

        public static int lerp(float pDelta, int pMin, int pMax) {
            int $$3 = ARGB32.lerpInt(pDelta, ARGB32.alpha(pMin), ARGB32.alpha(pMax));
            int $$4 = ARGB32.lerpInt(pDelta, ARGB32.red(pMin), ARGB32.red(pMax));
            int $$5 = ARGB32.lerpInt(pDelta, ARGB32.green(pMin), ARGB32.green(pMax));
            int $$6 = ARGB32.lerpInt(pDelta, ARGB32.blue(pMin), ARGB32.blue(pMax));
            return ARGB32.color($$3, $$4, $$5, $$6);
        }

        public static int lerpInt(float pDelta, int pStart, int pEnd) {
            return pStart + ARGB32.floor(pDelta * (float)(pEnd - pStart));
        }

        public static int floor(float pValue) {
            return MathUtil.floor(pValue);
        }
    }

    public static class ABGR32 {
        public static int alpha(int pPackedColor) {
            return pPackedColor >>> 24;
        }

        public static int red(int pPackedColor) {
            return pPackedColor & 0xFF;
        }

        public static int green(int pPackedColor) {
            return pPackedColor >> 8 & 0xFF;
        }

        public static int blue(int pPackedColor) {
            return pPackedColor >> 16 & 0xFF;
        }

        public static int transparent(int pPackedColor) {
            return pPackedColor & 0xFFFFFF;
        }

        public static int opaque(int pPackedColor) {
            return pPackedColor | 0xFF000000;
        }

        public static int color(int pAlpha, int pBlue, int pGreen, int pRed) {
            return pAlpha << 24 | pBlue << 16 | pGreen << 8 | pRed;
        }

        public static int color(int pAlpha, int pPackedColor) {
            return pAlpha << 24 | pPackedColor & 0xFFFFFF;
        }
    }
}

