/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util;

import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.forge.cache.GeckoLibCache;
import software.bernie.geckolib.forge.cache.object.GeoCube;
import software.bernie.geckolib.forge.util.mc.Axis;
import software.bernie.geckolib.forge.util.mc.ItemDisplayContext;
import software.bernie.geckolib.forge.util.mc.ItemTransforms;
import software.bernie.geckolib.forge.util.mc.PoseStack;
import software.bernie.geckolib.forge.util.mc.Vec3;
import software.bernie.libs.joml.Matrix4f;
import software.bernie.libs.joml.Quaternionf;
import software.bernie.libs.joml.Vector3f;

public final class RenderUtil {
    public static float getFrameTime() {
        return Minecraft.func_71410_x().field_71428_T.field_74281_c;
    }

    public static void translateMatrixToBone(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.translate(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(PoseStack poseStack, CoreGeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.mulPose(Axis.ZP.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.mulPose(Axis.YP.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.mulPose(Axis.XP.rotation(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(PoseStack poseStack, GeoCube cube) {
        Vec3 rotation = cube.rotation();
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.z()));
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, (float)rotation.y(), 0.0f));
        poseStack.mulPose(new Quaternionf().rotationXYZ((float)rotation.x(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(pivot.x() / 16.0, pivot.y() / 16.0, pivot.z() / 16.0);
    }

    public static void translateToPivotPoint(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.translate(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(-pivot.x() / 16.0, -pivot.y() / 16.0, -pivot.z() / 16.0);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, CoreGeoBone bone) {
        poseStack.translate(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(PoseStack poseStack, CoreGeoBone bone) {
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f(inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul(baseMatrix);
        return inputMatrix;
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add(new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return (double)Minecraft.func_71386_F() / 50.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static Vec3 arrayToVec(double[] array) {
        return new Vec3(array[0], array[1], array[2]);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().y() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().x() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().x() == 0.0 || cube.size().y() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(EnumFacing direction) {
        switch (direction) {
            case SOUTH: {
                return 90.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    public static PoseStack applyTransform(PoseStack poseStack, ResourceLocation transformResource, ItemDisplayContext cameraTransformType) {
        ItemTransforms transforms = GeckoLibCache.getTransforms().get(transformResource);
        if (transforms == null) {
            transforms = ItemTransforms.NO_TRANSFORMS;
        }
        transforms.getTransform(cameraTransformType).apply(false, poseStack);
        return poseStack;
    }
}

