/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib.forge.util.ModTextureUtil;

@SideOnly(value=Side.CLIENT)
public final class NativeImage
implements AutoCloseable {
    private final Format format;
    private final int width;
    private final int height;
    private final boolean useStbFree;
    private ByteBuffer pixels;
    private final long size;

    public NativeImage(int pWidth, int pHeight, boolean pUseCalloc) {
        this(Format.RGBA, pWidth, pHeight, pUseCalloc);
    }

    public NativeImage(Format pFormat, int pWidth, int pHeight, boolean pUseCalloc) {
        if (pWidth > 0 && pHeight > 0) {
            this.format = pFormat;
            this.width = pWidth;
            this.height = pHeight;
            this.size = (long)pWidth * (long)pHeight * (long)pFormat.components();
            this.useStbFree = false;
            if (pUseCalloc) {
                this.pixels = ByteBuffer.allocateDirect((int)this.size);
                this.zeroFillBuffer(this.pixels);
            } else {
                this.pixels = ByteBuffer.allocateDirect((int)this.size);
            }
        } else {
            throw new IllegalArgumentException("Invalid texture size: " + pWidth + "x" + pHeight);
        }
    }

    private NativeImage(Format pFormat, int pWidth, int pHeight, boolean pUseStbFree, ByteBuffer pPixels) {
        if (pWidth <= 0 || pHeight <= 0) {
            throw new IllegalArgumentException("Invalid texture size: " + pWidth + "x" + pHeight);
        }
        this.format = pFormat;
        this.width = pWidth;
        this.height = pHeight;
        this.useStbFree = pUseStbFree;
        this.pixels = pPixels;
        this.size = (long)pWidth * (long)pHeight * (long)pFormat.components();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.format) + " " + this.width + "x" + this.height + "@" + this.pixels + (this.useStbFree ? "S" : "N") + "]";
    }

    private void zeroFillBuffer(ByteBuffer buffer) {
        for (int i = 0; i < buffer.capacity(); ++i) {
            buffer.put(i, (byte)0);
        }
    }

    private boolean isOutsideBounds(int pX, int pY) {
        return pX < 0 || pX >= this.width || pY < 0 || pY >= this.height;
    }

    public static NativeImage read(InputStream pTextureStream) throws IOException {
        return NativeImage.read(Format.RGBA, pTextureStream);
    }

    public static NativeImage read(@Nullable Format format, InputStream textureStream) throws IOException {
        NativeImage nativeImage;
        try {
            nativeImage = NativeImage.read(format, ImageIO.read(textureStream));
        }
        finally {
            IOUtils.closeQuietly((InputStream)textureStream);
        }
        return nativeImage;
    }

    public static NativeImage read(BufferedImage bufferedImage) throws IOException {
        return NativeImage.read(Format.RGBA, bufferedImage);
    }

    public static NativeImage read(@Nullable Format format, BufferedImage bufferedImage) throws IOException {
        if (format == null) {
            throw new UnsupportedOperationException("Format cannot be null in OpenGL 2.");
        }
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid texture dimensions: " + width + "x" + height);
        }
        int textureId = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        ByteBuffer pixelData = ModTextureUtil.readResource(bufferedImage);
        GL11.glTexImage2D((int)3553, (int)0, (int)format.glFormat(), (int)width, (int)height, (int)0, (int)format.glFormat(), (int)5121, (ByteBuffer)pixelData);
        return new NativeImage(format, width, height, true, pixelData);
    }

    private static void setFilter(boolean linear, boolean mipmap) {
        if (linear) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)(mipmap ? 9987 : 9729));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)(mipmap ? 9984 : 9728));
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    private void checkAllocated() {
        if (this.pixels == null || !this.pixels.hasRemaining()) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.pixels != null) {
            this.pixels = null;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Format format() {
        return this.format;
    }

    public int getPixelRGBA(int x, int y) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "getPixelRGBA only works on RGBA images; have %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(x, y)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "(%s, %s) outside of image bounds (%s, %s)", x, y, this.width, this.height));
        }
        this.checkAllocated();
        int index = (x + y * this.width) * 4;
        return this.pixels.getInt(index);
    }

    public void setPixelRGBA(int x, int y, int abgrColor) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "setPixelRGBA only works on RGBA images; have %s", new Object[]{this.format}));
        }
        if (this.isOutsideBounds(x, y)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "(%s, %s) outside of image bounds (%s, %s)", x, y, this.width, this.height));
        }
        this.checkAllocated();
        int index = (x + y * this.width) * 4;
        this.pixels.putInt(index, abgrColor);
    }

    public NativeImage mappedCopy(IntUnaryOperator function) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "function application only works on RGBA images; have %s", new Object[]{this.format}));
        }
        this.checkAllocated();
        NativeImage newImage = new NativeImage(this.width, this.height, false);
        IntBuffer srcBuffer = this.pixels.asIntBuffer();
        IntBuffer destBuffer = newImage.pixels.asIntBuffer();
        int pixelCount = this.width * this.height;
        for (int i = 0; i < pixelCount; ++i) {
            destBuffer.put(i, function.applyAsInt(srcBuffer.get(i)));
        }
        return newImage;
    }

    public void applyToAllPixels(IntUnaryOperator function) {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "function application only works on RGBA images; have %s", new Object[]{this.format}));
        }
        this.checkAllocated();
        IntBuffer pixelBuffer = this.pixels.asIntBuffer();
        int pixelCount = this.width * this.height;
        for (int i = 0; i < pixelCount; ++i) {
            int pixel = pixelBuffer.get(i);
            pixelBuffer.put(i, function.applyAsInt(pixel));
        }
    }

    public int[] getPixelsRGBA() {
        if (this.format != Format.RGBA) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "getPixelsRGBA only works on RGBA images; have %s", new Object[]{this.format}));
        }
        this.checkAllocated();
        int[] pixelArray = new int[this.width * this.height];
        IntBuffer pixelBuffer = this.pixels.asIntBuffer();
        pixelBuffer.get(pixelArray);
        return pixelArray;
    }

    public void upload(int pLevel, int pXOffset, int pYOffset, boolean pMipmap) {
        this.upload(pLevel, pXOffset, pYOffset, 0, 0, this.width, this.height, false, pMipmap);
    }

    public void upload(int pLevel, int pXOffset, int pYOffset, int pUnpackSkipPixels, int pUnpackSkipRows, int pWidth, int pHeight, boolean pMipmap, boolean pAutoClose) {
        this.upload(pLevel, pXOffset, pYOffset, pUnpackSkipPixels, pUnpackSkipRows, pWidth, pHeight, false, false, pMipmap, pAutoClose);
    }

    public void upload(int pLevel, int pXOffset, int pYOffset, int pUnpackSkipPixels, int pUnpackSkipRows, int pWidth, int pHeight, boolean pBlur, boolean pClamp, boolean pMipmap, boolean pAutoClose) {
        this._upload(pLevel, pXOffset, pYOffset, pUnpackSkipPixels, pUnpackSkipRows, pWidth, pHeight, pBlur, pClamp, pMipmap, pAutoClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _upload(int level, int xOffset, int yOffset, int unpackSkipPixels, int unpackSkipRows, int width, int height, boolean blur, boolean clamp, boolean mipmap, boolean autoClose) {
        try {
            this.checkAllocated();
            NativeImage.setFilter(blur, mipmap);
            if (width == this.getWidth()) {
                GL11.glPixelStorei((int)3314, (int)0);
            } else {
                GL11.glPixelStorei((int)3314, (int)this.getWidth());
            }
            GL11.glPixelStorei((int)3316, (int)unpackSkipPixels);
            GL11.glPixelStorei((int)3315, (int)unpackSkipRows);
            this.format.setUnpackPixelStoreState();
            GL11.glTexSubImage2D((int)3553, (int)level, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)this.format.glFormat(), (int)5121, (ByteBuffer)this.pixels);
            if (clamp) {
                GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            }
            GL11.glPixelStorei((int)3314, (int)0);
            GL11.glPixelStorei((int)3316, (int)0);
            GL11.glPixelStorei((int)3315, (int)0);
        }
        finally {
            if (autoClose) {
                this.close();
            }
        }
    }

    public void drawPixels() {
        this.format.setUnpackPixelStoreState();
        GL11.glDrawPixels((int)this.width, (int)this.height, (int)this.format.glFormat(), (int)5121, (ByteBuffer)this.pixels);
    }

    public void copyFrom(NativeImage other) {
        if (other.format != this.format) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        this.checkAllocated();
        other.checkAllocated();
        int components = this.format.components();
        if (this.width == other.width) {
            ByteBuffer srcBuffer = other.pixels.duplicate();
            ByteBuffer destBuffer = this.pixels.duplicate();
            srcBuffer.rewind();
            destBuffer.rewind();
            destBuffer.put(srcBuffer);
        } else {
            int minWidth = Math.min(this.getWidth(), other.getWidth());
            int minHeight = Math.min(this.getHeight(), other.getHeight());
            for (int y = 0; y < minHeight; ++y) {
                int srcOffset = y * other.getWidth() * components;
                int destOffset = y * this.getWidth() * components;
                ByteBuffer srcRow = other.pixels.duplicate();
                ByteBuffer destRow = this.pixels.duplicate();
                srcRow.position(srcOffset).limit(srcOffset + minWidth * components);
                destRow.position(destOffset).limit(destOffset + minWidth * components);
                destRow.put(srcRow);
            }
        }
    }

    public void fillRect(int x, int y, int width, int height, int value) {
        for (int i = y; i < y + height; ++i) {
            for (int j = x; j < x + width; ++j) {
                this.setPixelRGBA(j, i, value);
            }
        }
    }

    public void copyRect(int xFrom, int yFrom, int xToDelta, int yToDelta, int width, int height, boolean mirrorX, boolean mirrorY) {
        this.copyRect(this, xFrom, yFrom, xFrom + xToDelta, yFrom + yToDelta, width, height, mirrorX, mirrorY);
    }

    public void copyRect(NativeImage source, int xFrom, int yFrom, int xTo, int yTo, int width, int height, boolean mirrorX, boolean mirrorY) {
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int srcX = mirrorX ? width - 1 - j : j;
                int srcY = mirrorY ? height - 1 - i : i;
                int pixel = this.getPixelRGBA(xFrom + j, yFrom + i);
                source.setPixelRGBA(xTo + srcX, yTo + srcY, pixel);
            }
        }
    }

    public void flipY() {
        this.checkAllocated();
        int components = this.format.components();
        int rowSize = this.getWidth() * components;
        ByteBuffer tempRow = ByteBuffer.allocateDirect(rowSize);
        for (int y = 0; y < this.getHeight() / 2; ++y) {
            int topOffset = y * this.getWidth() * components;
            int bottomOffset = (this.getHeight() - 1 - y) * this.getWidth() * components;
            this.pixels.position(topOffset).limit(topOffset + rowSize);
            tempRow.clear();
            tempRow.put(this.pixels);
            this.pixels.position(bottomOffset).limit(bottomOffset + rowSize);
            ByteBuffer bottomRow = this.pixels.slice();
            this.pixels.position(topOffset);
            this.pixels.put(bottomRow);
            tempRow.flip();
            this.pixels.position(bottomOffset);
            this.pixels.put(tempRow);
        }
    }

    public void writeToFile(Path pPath) throws IOException {
        this.checkAllocated();
        try (OutputStream outputStream = Files.newOutputStream(pPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            if (!ImageIO.write((RenderedImage)NativeImage.byteBufferToBufferedImage(this.pixels, this.width, this.height), "PNG", outputStream)) {
                throw new IOException("Could not write image to the PNG file: " + pPath.toAbsolutePath());
            }
        }
    }

    public static BufferedImage byteBufferToBufferedImage(ByteBuffer buffer, int width, int height) {
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int i = (y * width + x) * 4;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = buffer.get(i + 3) & 0xFF;
                pixels[y * width + x] = a << 24 | r << 16 | g << 8 | b;
            }
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        image.setRGB(0, 0, width, height, pixels, 0, width);
        return image;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum InternalGlFormat {
        RGBA(6408),
        RGB(6407),
        RG(33319),
        RED(6403);

        private final int glFormat;

        private InternalGlFormat(int pGlFormat) {
            this.glFormat = pGlFormat;
        }

        public int glFormat() {
            return this.glFormat;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Format {
        RGBA(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        RGB(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        LUMINANCE_ALPHA(2, 33319, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        LUMINANCE(1, 6403, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        final int components;
        private final int glFormat;
        private final boolean hasRed;
        private final boolean hasGreen;
        private final boolean hasBlue;
        private final boolean hasLuminance;
        private final boolean hasAlpha;
        private final int redOffset;
        private final int greenOffset;
        private final int blueOffset;
        private final int luminanceOffset;
        private final int alphaOffset;
        private final boolean supportedByStb;

        private Format(int pComponents, int pGlFormat, boolean pHasRed, boolean pHasGreen, boolean pHasBlue, boolean pHasLuminance, boolean pHasAlpha, int pRedOffset, int pGreenOffset, int pBlueOffset, int pLuminanceOffset, int pAlphaOffset, boolean pSupportedByStb) {
            this.components = pComponents;
            this.glFormat = pGlFormat;
            this.hasRed = pHasRed;
            this.hasGreen = pHasGreen;
            this.hasBlue = pHasBlue;
            this.hasLuminance = pHasLuminance;
            this.hasAlpha = pHasAlpha;
            this.redOffset = pRedOffset;
            this.greenOffset = pGreenOffset;
            this.blueOffset = pBlueOffset;
            this.luminanceOffset = pLuminanceOffset;
            this.alphaOffset = pAlphaOffset;
            this.supportedByStb = pSupportedByStb;
        }

        public int components() {
            return this.components;
        }

        public void setPackPixelStoreState() {
            GL11.glPixelStorei((int)3333, (int)this.components());
        }

        public void setUnpackPixelStoreState() {
            GL11.glPixelStorei((int)3317, (int)this.components());
        }

        public int glFormat() {
            return this.glFormat;
        }

        public boolean hasRed() {
            return this.hasRed;
        }

        public boolean hasGreen() {
            return this.hasGreen;
        }

        public boolean hasBlue() {
            return this.hasBlue;
        }

        public boolean hasLuminance() {
            return this.hasLuminance;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }

        public int redOffset() {
            return this.redOffset;
        }

        public int greenOffset() {
            return this.greenOffset;
        }

        public int blueOffset() {
            return this.blueOffset;
        }

        public int luminanceOffset() {
            return this.luminanceOffset;
        }

        public int alphaOffset() {
            return this.alphaOffset;
        }

        public boolean hasLuminanceOrRed() {
            return this.hasLuminance || this.hasRed;
        }

        public boolean hasLuminanceOrGreen() {
            return this.hasLuminance || this.hasGreen;
        }

        public boolean hasLuminanceOrBlue() {
            return this.hasLuminance || this.hasBlue;
        }

        public boolean hasLuminanceOrAlpha() {
            return this.hasLuminance || this.hasAlpha;
        }

        public int luminanceOrRedOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.redOffset;
        }

        public int luminanceOrGreenOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.greenOffset;
        }

        public int luminanceOrBlueOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.blueOffset;
        }

        public int luminanceOrAlphaOffset() {
            return this.hasLuminance ? this.luminanceOffset : this.alphaOffset;
        }

        public boolean supportedByStb() {
            return this.supportedByStb;
        }

        static Format getStbFormat(int pChannels) {
            switch (pChannels) {
                case 1: {
                    return LUMINANCE;
                }
                case 2: {
                    return LUMINANCE_ALPHA;
                }
                case 3: {
                    return RGB;
                }
            }
            return RGBA;
        }
    }
}

