/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util;

import cpw.mods.fml.client.SplashProgress;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.ThreadLocalRandom;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib.forge.util.NativeImage;

public class ModTextureUtil {
    public static final int NO_WHITE_U = 0;
    public static final int RED_OVERLAY_V = 3;
    public static final int WHITE_OVERLAY_V = 10;
    public static final int NO_OVERLAY = ModTextureUtil.pack(0, 10);
    private static final boolean IS_RUNNING_IN_IDE = true;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final double BUFFER_GROWTH_FACTOR = 1.5;

    public static int generateTextureId() {
        int[] tempTextures = new int[ThreadLocalRandom.current().nextInt(15) + 1];
        for (int i = 0; i < tempTextures.length; ++i) {
            tempTextures[i] = GL11.glGenTextures();
        }
        int finalTextureId = GL11.glGenTextures();
        for (int tempTexture : tempTextures) {
            GL11.glDeleteTextures((int)tempTexture);
        }
        return finalTextureId;
    }

    public static void releaseTextureId(int textureId) {
        GL11.glDeleteTextures((int)textureId);
    }

    public static void prepareImage(int pTextureId, int pWidth, int pHeight) {
        ModTextureUtil.prepareImage(NativeImage.InternalGlFormat.RGBA, pTextureId, 0, pWidth, pHeight);
    }

    public static void prepareImage(NativeImage.InternalGlFormat pPixelFormat, int pTextureId, int pWidth, int pHeight) {
        ModTextureUtil.prepareImage(pPixelFormat, pTextureId, 0, pWidth, pHeight);
    }

    public static void prepareImage(int pTextureId, int pMipmapLevel, int pWidth, int pHeight) {
        ModTextureUtil.prepareImage(NativeImage.InternalGlFormat.RGBA, pTextureId, pMipmapLevel, pWidth, pHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareImage(NativeImage.InternalGlFormat pixelFormat, int textureId, int mipmapLevel, int width, int height) {
        Class<SplashProgress> clazz = SplashProgress.class;
        synchronized (SplashProgress.class) {
            ModTextureUtil.deleteTexture(textureId);
            ModTextureUtil.bindTexture(textureId);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (mipmapLevel > 0) {
                GL11.glTexParameteri((int)3553, (int)33085, (int)mipmapLevel);
                GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                GL11.glTexParameterf((int)3553, (int)33083, (float)mipmapLevel);
                GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            }
            for (int i1 = 0; i1 <= mipmapLevel; ++i1) {
                GL11.glTexImage2D((int)3553, (int)i1, (int)pixelFormat.glFormat(), (int)(width >> i1), (int)(height >> i1), (int)0, (int)32993, (int)33639, (IntBuffer)null);
            }
            return;
        }
    }

    private static void bind(int textureId) {
        GL11.glBindTexture((int)3553, (int)textureId);
    }

    public static ByteBuffer readResource(InputStream inputStream) throws IOException {
        ReadableByteChannel channel = Channels.newChannel(inputStream);
        if (channel instanceof SeekableByteChannel) {
            return ModTextureUtil.readResource(channel, (int)((SeekableByteChannel)channel).size() + 1);
        }
        return ModTextureUtil.readResource(channel, 8192);
    }

    public static ByteBuffer readResource(BufferedImage image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4);
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int pixel = pixels[h * width + w];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return buffer;
    }

    private static ByteBuffer readResource(ReadableByteChannel channel, int initialSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(initialSize);
        while (channel.read(buffer) != -1) {
            if (buffer.hasRemaining()) continue;
            int newCapacity = (int)((double)buffer.capacity() * 1.5);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            buffer.flip();
            newBuffer.put(buffer);
            buffer = newBuffer;
        }
        buffer.flip();
        return buffer;
    }

    public static void bindTexture(int pTextureId) {
        GL11.glBindTexture((int)3553, (int)pTextureId);
    }

    public static void deleteTexture(int pTextureId) {
        GL11.glDeleteTextures((int)pTextureId);
    }

    public static int pack(int pU, int pV) {
        return pU | pV << 16;
    }
}

