/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.forge.loading.json.raw.Bone;
import software.bernie.geckolib.forge.loading.json.raw.Cube;
import software.bernie.geckolib.forge.loading.json.raw.FaceUV;
import software.bernie.geckolib.forge.loading.json.raw.LocatorClass;
import software.bernie.geckolib.forge.loading.json.raw.LocatorValue;
import software.bernie.geckolib.forge.loading.json.raw.MinecraftGeometry;
import software.bernie.geckolib.forge.loading.json.raw.Model;
import software.bernie.geckolib.forge.loading.json.raw.ModelProperties;
import software.bernie.geckolib.forge.loading.json.raw.PolyMesh;
import software.bernie.geckolib.forge.loading.json.raw.PolysUnion;
import software.bernie.geckolib.forge.loading.json.raw.TextureMesh;
import software.bernie.geckolib.forge.loading.json.raw.UVFaces;
import software.bernie.geckolib.forge.loading.json.raw.UVUnion;
import software.bernie.geckolib.forge.loading.json.typeadapter.BakedAnimationsAdapter;
import software.bernie.geckolib.forge.loading.json.typeadapter.KeyFramesAdapter;
import software.bernie.geckolib.forge.loading.object.BakedAnimations;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.mc.ItemTransform;
import software.bernie.geckolib.forge.util.mc.ItemTransforms;

public final class JsonUtil {
    public static final Gson GEO_GSON = new GsonBuilder().registerTypeAdapter(Bone.class, Bone.deserializer()).registerTypeAdapter(Cube.class, Cube.deserializer()).registerTypeAdapter(FaceUV.class, FaceUV.deserializer()).registerTypeAdapter(LocatorClass.class, LocatorClass.deserializer()).registerTypeAdapter(LocatorValue.class, LocatorValue.deserializer()).registerTypeAdapter(MinecraftGeometry.class, MinecraftGeometry.deserializer()).registerTypeAdapter(Model.class, Model.deserializer()).registerTypeAdapter(ModelProperties.class, ModelProperties.deserializer()).registerTypeAdapter(PolyMesh.class, PolyMesh.deserializer()).registerTypeAdapter(PolysUnion.class, PolysUnion.deserializer()).registerTypeAdapter(TextureMesh.class, TextureMesh.deserializer()).registerTypeAdapter(UVFaces.class, UVFaces.deserializer()).registerTypeAdapter(UVUnion.class, UVUnion.deserializer()).registerTypeAdapter(Animation.Keyframes.class, (Object)new KeyFramesAdapter()).registerTypeAdapter(BakedAnimations.class, (Object)new BakedAnimationsAdapter()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).create();

    public static double[] jsonArrayToDoubleArray(@Nullable JsonArray array) throws JsonParseException {
        if (array == null) {
            return new double[3];
        }
        double[] output = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            output[i] = array.get(i).getAsDouble();
        }
        return output;
    }

    public static <T> T[] jsonArrayToObjectArray(JsonArray array, JsonDeserializationContext context, Class<T> objectClass) {
        Object[] objArray = (Object[])Array.newInstance(objectClass, array.size());
        for (int i = 0; i < array.size(); ++i) {
            objArray[i] = context.deserialize(array.get(i), objectClass);
        }
        return objArray;
    }

    public static <T> List<T> jsonArrayToList(@Nullable JsonArray array, Function<JsonElement, T> elementTransformer) {
        if (array == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList(array.size());
        for (JsonElement element : array) {
            list.add(elementTransformer.apply(element));
        }
        return list;
    }

    public static <T> Map<String, T> jsonObjToMap(JsonObject obj, JsonDeserializationContext context, Class<T> objectType) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(obj.entrySet().size());
        for (Map.Entry entry : obj.entrySet()) {
            map.put(entry.getKey(), context.deserialize((JsonElement)entry.getValue(), objectType));
        }
        return map;
    }

    @Nullable
    public static Long getOptionalLong(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Long.valueOf(GsonHelper.getAsLong(obj, elementName)) : null;
    }

    @Nullable
    public static Boolean getOptionalBoolean(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Boolean.valueOf(GsonHelper.getAsBoolean(obj, elementName)) : null;
    }

    @Nullable
    public static Float getOptionalFloat(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Float.valueOf(GsonHelper.getAsFloat(obj, elementName)) : null;
    }

    @Nullable
    public static Double getOptionalDouble(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Double.valueOf(GsonHelper.getAsDouble(obj, elementName)) : null;
    }

    @Nullable
    public static Integer getOptionalInteger(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Integer.valueOf(GsonHelper.getAsInt(obj, elementName)) : null;
    }
}

