/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.resource;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import software.bernie.geckolib.forge.util.NativeImage;
import software.bernie.geckolib.forge.util.mc.FastColor;

public class GeoGlowingTextureMeta {
    private final List<Pixel> pixels;

    public GeoGlowingTextureMeta(List<Pixel> pixels) {
        this.pixels = pixels;
    }

    public static GeoGlowingTextureMeta fromExistingImage(NativeImage glowLayer) {
        ObjectArrayList<Pixel> pixels = new ObjectArrayList<Pixel>();
        for (int x = 0; x < glowLayer.getWidth(); ++x) {
            for (int y = 0; y < glowLayer.getHeight(); ++y) {
                int color = glowLayer.getPixelRGBA(x, y);
                if (color == 0) continue;
                pixels.add(new Pixel(x, y, FastColor.ABGR32.alpha(color)));
            }
        }
        if (pixels.isEmpty()) {
            throw new IllegalStateException("Invalid glow layer texture provided, must have at least one pixel!");
        }
        return new GeoGlowingTextureMeta(pixels);
    }

    public void createImageMask(NativeImage originalImage, NativeImage newImage) {
        for (Pixel pixel : this.pixels) {
            int color = originalImage.getPixelRGBA(pixel.x, pixel.y);
            if (pixel.alpha > 0) {
                color = FastColor.ABGR32.color(pixel.alpha, FastColor.ABGR32.blue(color), FastColor.ABGR32.green(color), FastColor.ABGR32.red(color));
            }
            newImage.setPixelRGBA(pixel.x, pixel.y, color);
            originalImage.setPixelRGBA(pixel.x, pixel.y, 0);
        }
    }

    private static class Pixel {
        public final int x;
        public final int y;
        public final int alpha;

        private Pixel(int x, int y, int alpha) {
            this.x = x;
            this.y = y;
            this.alpha = alpha;
        }
    }
}

