/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.renderer.layer;

import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.forge.cache.object.BakedGeoModel;
import software.bernie.geckolib.forge.cache.object.GeoBone;
import software.bernie.geckolib.forge.model.GeoModel;
import software.bernie.geckolib.forge.renderer.GeoRenderer;
import software.bernie.geckolib.forge.util.RenderStateShard;
import software.bernie.geckolib.forge.util.mc.PoseStack;

public abstract class GeoRenderLayer<T extends GeoAnimatable> {
    protected final GeoRenderer<T> renderer;
    protected RenderStateShard renderStateShard = new RenderStateShard(() -> {}, () -> {});

    public GeoRenderLayer(GeoRenderer<T> entityRendererIn) {
        this.renderer = entityRendererIn;
    }

    public GeoRenderLayer<T> setRenderStateShard(RenderStateShard renderStateShard) {
        this.renderStateShard = renderStateShard;
        return this;
    }

    public RenderStateShard getRenderStateShard(T animatable) {
        return this.renderStateShard;
    }

    public GeoModel<T> getGeoModel() {
        return this.renderer.getGeoModel();
    }

    public BakedGeoModel getDefaultBakedModel(T animatable) {
        return this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(animatable));
    }

    public GeoRenderer<T> getRenderer() {
        return this.renderer;
    }

    protected ResourceLocation getTextureResource(T animatable) {
        return this.renderer.getTextureLocation(animatable);
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, float partialTick, int packedLight, int packedOverlay) {
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, float partialTick, int packedLight, int packedOverlay) {
    }

    public void renderForBone(PoseStack poseStack, T animatable, GeoBone bone, float partialTick, int packedLight, int packedOverlay) {
    }
}

