/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.renderer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.forge.cache.object.BakedGeoModel;
import software.bernie.geckolib.forge.cache.object.GeoBone;
import software.bernie.geckolib.forge.cache.object.GeoCube;
import software.bernie.geckolib.forge.cache.object.GeoQuad;
import software.bernie.geckolib.forge.cache.object.GeoVertex;
import software.bernie.geckolib.forge.cache.texture.AnimatableTexture;
import software.bernie.geckolib.forge.model.GeoModel;
import software.bernie.geckolib.forge.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.forge.util.RenderStateShard;
import software.bernie.geckolib.forge.util.RenderUtil;
import software.bernie.geckolib.forge.util.mc.PoseStack;
import software.bernie.libs.joml.Matrix3f;
import software.bernie.libs.joml.Matrix4f;
import software.bernie.libs.joml.Vector3f;
import software.bernie.libs.joml.Vector4f;

public interface GeoRenderer<T extends GeoAnimatable> {
    public static final Tessellator tess = Tessellator.field_78398_a;

    public GeoModel<T> getGeoModel();

    public T getAnimatable();

    default public ResourceLocation getTextureLocation(T animatable) {
        return this.getGeoModel().getTextureResource(animatable);
    }

    default public ResourceLocation getTransformsResource(T animatable) {
        return this.getGeoModel().getTransformsResource(animatable);
    }

    default public RenderStateShard getRenderStateShard(T animatable) {
        return new RenderStateShard(() -> {}, () -> {});
    }

    default public List<GeoRenderLayer<T>> getRenderLayers() {
        return new ArrayList<GeoRenderLayer<T>>();
    }

    default public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    default public int getPackedOverlay(T animatable, float u, float partialTick) {
        return 0;
    }

    default public long getInstanceId(T animatable) {
        return animatable.hashCode();
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public void defaultRender(PoseStack poseStack, T animatable, float yaw, float partialTick, int packedLight) {
        BakedGeoModel model = this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(animatable));
        this.defaultRender(model, poseStack, animatable, yaw, partialTick, packedLight);
    }

    default public void defaultRender(BakedGeoModel model, PoseStack poseStack, T animatable, float yaw, float partialTick, int packedLight) {
        poseStack.pushPose();
        Color renderColor = this.getRenderColor(animatable, partialTick, packedLight);
        float red = renderColor.getRedFloat();
        float green = renderColor.getGreenFloat();
        float blue = renderColor.getBlueFloat();
        float alpha = renderColor.getAlphaFloat();
        int packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        RenderStateShard renderStateShard = this.getRenderStateShard(animatable);
        renderStateShard.setupRenderState();
        ResourceLocation resource = this.getTextureLocation(animatable);
        if (resource != null) {
            this.bindGeoTexture(resource);
        }
        this.preRender(poseStack, animatable, model, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (this.firePreRenderEvent(poseStack, model, partialTick, packedLight)) {
            this.preApplyRenderLayers(poseStack, animatable, model, packedLight, packedLight, packedOverlay);
            this.actuallyRender(poseStack, animatable, model, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            this.applyRenderLayers(poseStack, animatable, model, partialTick, packedLight, packedOverlay);
            this.postRender(poseStack, animatable, model, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
            this.firePostRenderEvent(poseStack, model, partialTick, packedLight);
        }
        renderStateShard.clearRenderState();
        poseStack.popPose();
        this.renderFinal(poseStack, animatable, model, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    default public void bindGeoTexture(ResourceLocation resource) {
        ITextureObject object = Minecraft.func_71410_x().func_110434_K().func_110581_b(resource);
        if (object == null) {
            AnimatableTexture animatableTexture = new AnimatableTexture(resource);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resource, (ITextureObject)animatableTexture);
            if (!animatableTexture.isAnimated()) {
                object = new SimpleTexture(resource);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(resource, object);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
    }

    default public void reRender(BakedGeoModel model, PoseStack poseStack, T animatable, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.pushPose();
        this.preRender(poseStack, animatable, model, true, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.actuallyRender(poseStack, animatable, model, true, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.postRender(poseStack, animatable, model, true, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.popPose();
    }

    default public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        tess.func_78382_b();
        this.updateAnimatedTextureFrame(animatable);
        for (GeoBone group : model.topLevelBones()) {
            if (!this.isRenderBone(poseStack, animatable, group)) continue;
            this.renderRecursively(poseStack, animatable, group, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
        tess.func_78381_a();
    }

    default public boolean isRenderBone(PoseStack poseStack, T animatable, GeoBone group) {
        return true;
    }

    default public void preApplyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, float partialTick, int packedLight, int packedOverlay) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(poseStack, animatable, model, partialTick, packedLight, packedOverlay);
        }
    }

    default public void applyRenderLayersForBone(PoseStack poseStack, T animatable, GeoBone bone, float partialTick, int packedLight, int packedOverlay) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.renderForBone(poseStack, animatable, bone, partialTick, packedLight, packedOverlay);
        }
    }

    default public void applyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, float partialTick, int packedLight, int packedOverlay) {
        for (GeoRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.render(poseStack, animatable, model, partialTick, packedLight, packedOverlay);
        }
    }

    default public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    default public void postRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    default public void renderFinal(PoseStack poseStack, T animatable, BakedGeoModel model, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    default public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.pushPose();
        RenderUtil.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(poseStack, bone, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, animatable, bone, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, animatable, bone, false, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.popPose();
    }

    default public void renderCubesOfBone(PoseStack poseStack, GeoBone bone, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.getCubes()) {
            poseStack.pushPose();
            this.renderCube(poseStack, cube, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.popPose();
        }
    }

    default public void renderChildBones(PoseStack poseStack, T animatable, GeoBone bone, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (GeoBone childBone : bone.getChildBones()) {
            this.renderRecursively(poseStack, animatable, childBone, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void renderCube(PoseStack poseStack, GeoCube cube, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        RenderUtil.translateToPivotPoint(poseStack, cube);
        RenderUtil.rotateMatrixAroundCube(poseStack, cube);
        RenderUtil.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.last().normal();
        Matrix4f poseState = poseStack.last().pose();
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f(quad.normal()));
            RenderUtil.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(quad, poseState, normal, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    default public void createVerticesOfQuad(GeoQuad quad, Matrix4f poseState, Vector3f normal, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector4f position = new Vector4f(vertex.position().x, vertex.position().y, vertex.position().z, 1.0f);
            poseState.transform(position);
            tess.func_78369_a(red, green, blue, alpha);
            tess.func_78375_b(normal.x, normal.y, normal.z);
            tess.func_78374_a((double)position.x, (double)position.y, (double)position.z, (double)vertex.texU(), (double)vertex.texV());
        }
    }

    public void fireCompileRenderLayersEvent();

    public boolean firePreRenderEvent(PoseStack var1, BakedGeoModel var2, float var3, int var4);

    public void firePostRenderEvent(PoseStack var1, BakedGeoModel var2, float var3, int var4);

    default public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            poseStack.scale(widthScale, heightScale, widthScale);
        }
    }

    public void updateAnimatedTextureFrame(T var1);

    public PoseStack applyTransform(PoseStack var1, T var2);
}

