/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.renderer;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.forge.animatable.GeoItem;
import software.bernie.geckolib.forge.cache.object.BakedGeoModel;
import software.bernie.geckolib.forge.cache.object.GeoBone;
import software.bernie.geckolib.forge.cache.texture.AnimatableTexture;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.model.GeoModel;
import software.bernie.geckolib.forge.renderer.GeoRenderer;
import software.bernie.geckolib.forge.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.forge.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.forge.util.RenderUtil;
import software.bernie.geckolib.forge.util.mc.ItemDisplayContext;
import software.bernie.geckolib.forge.util.mc.PoseStack;
import software.bernie.libs.joml.Matrix4f;

public class GeoItemRenderer<T extends Item>
implements IItemRenderer,
GeoRenderer<T> {
    public PoseStack poseStack = new PoseStack();
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected ItemStack currentItemStack;
    protected ItemDisplayContext renderPerspective;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoItemRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    public ItemStack getCurrentItemStack() {
        return this.currentItemStack;
    }

    public GeoItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public long getInstanceId(T animatable) {
        return GeoItem.getId(this.currentItemStack);
    }

    @Override
    public ResourceLocation getTextureLocation(T animatable) {
        return GeoRenderer.super.getTextureLocation((GeoAnimatable)animatable);
    }

    @Override
    public ResourceLocation getTransformsResource(T animatable) {
        return GeoRenderer.super.getTransformsResource((GeoAnimatable)animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoItemRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoItemRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoItemRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.itemRenderTranslations = new Matrix4f(poseStack.last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
        if (!isReRender) {
            poseStack.translate(0.5f, 0.51f, 0.5f);
        }
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        this.animatable = stack.func_77973_b();
        this.currentItemStack = stack;
        this.renderPerspective = ItemDisplayContext.transform(type);
        int packedLight = 0;
        GL11.glDisable((int)2884);
        this.poseStack.pushPose();
        this.poseStack = this.applyTransform(this.poseStack, this.animatable);
        this.defaultRender(this.poseStack, (GeoAnimatable)this.animatable, 0.0f, RenderUtil.getFrameTime(), packedLight);
        this.poseStack.popPose();
        GL11.glEnable((int)2884);
    }

    @Override
    public PoseStack applyTransform(PoseStack poseStack, T animatable) {
        if (this.renderPerspective == ItemDisplayContext.FIXED) {
            GL11.glTranslatef((float)0.0f, (float)0.15f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (this.renderPerspective == ItemDisplayContext.GUI) {
            GL11.glTranslated((double)8.0, (double)8.0, (double)0.0);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
        } else if (this.renderPerspective == ItemDisplayContext.GROUND) {
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        } else if (this.renderPerspective == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.4375f, (float)-0.38f, (float)-1.125f);
        } else if (this.renderPerspective == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            GL11.glTranslated((double)0.0, (double)0.55, (double)0.6);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)1.6f, (float)1.6f, (float)1.6f);
        }
        poseStack = RenderUtil.applyTransform(poseStack, this.getTransformsResource(animatable), this.renderPerspective);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        return poseStack;
    }

    @Override
    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender) {
            AnimationState<GeoAnimatable> animationState = new AnimationState<GeoAnimatable>((GeoAnimatable)animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(this.currentItemStack));
            animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
            animationState.setData(DataTickets.ITEMSTACK, this.currentItemStack);
            ((GeoAnimatable)animatable).getAnimatableInstanceCache().getManagerForId(instanceId).setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
            this.model.addAdditionalStateData((Item)((GeoAnimatable)animatable), instanceId, (BiConsumer<DataTicket<Item>, Item>)((BiConsumer<DataTicket, Item>)(x$0, x$1) -> animationState.setData(x$0, x$1)));
            this.model.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f(poseStack.last().pose());
        GeoRenderer.super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f(poseStack.last().pose());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations));
        }
        GeoRenderer.super.renderRecursively(poseStack, (GeoAnimatable)animatable, bone, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation(animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
    }

    @Override
    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, float partialTick, int packedLight) {
        return true;
    }

    @Override
    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, float partialTick, int packedLight) {
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack stack, IItemRenderer.ItemRendererHelper helper) {
        if (type == IItemRenderer.ItemRenderType.ENTITY && helper == IItemRenderer.ItemRendererHelper.BLOCK_3D) {
            return false;
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY && helper == IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK) {
            return false;
        }
        return type != IItemRenderer.ItemRenderType.EQUIPPED || helper != IItemRenderer.ItemRendererHelper.BLOCK_3D;
    }
}

