/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.renderer;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.forge.cache.object.BakedGeoModel;
import software.bernie.geckolib.forge.cache.object.GeoBone;
import software.bernie.geckolib.forge.cache.texture.AnimatableTexture;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.model.GeoModel;
import software.bernie.geckolib.forge.model.data.EntityModelData;
import software.bernie.geckolib.forge.renderer.GeoRenderer;
import software.bernie.geckolib.forge.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.forge.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.forge.util.RenderUtil;
import software.bernie.geckolib.forge.util.mc.Axis;
import software.bernie.geckolib.forge.util.mc.MathUtil;
import software.bernie.geckolib.forge.util.mc.PoseStack;
import software.bernie.geckolib.forge.util.mc.Vec3;
import software.bernie.libs.eliotlash.mclib.utils.Interpolations;
import software.bernie.libs.joml.Matrix4f;
import software.bernie.libs.joml.Vector3f;

public class GeoEntityRenderer<T extends Entity>
extends Render
implements GeoRenderer<T> {
    public PoseStack poseStack = new PoseStack();
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoEntityRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(T animatable) {
        return animatable.func_145782_y();
    }

    @Override
    public ResourceLocation getTextureLocation(T animatable) {
        return GeoRenderer.super.getTextureLocation((GeoAnimatable)animatable);
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoEntityRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoEntityRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoEntityRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f(poseStack.last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.animatable = entity;
        int packedLight = 0;
        GL11.glDisable((int)2884);
        this.poseStack.pushPose();
        this.poseStack.translate(x, y, z);
        this.defaultRender(this.poseStack, (GeoAnimatable)this.animatable, entityYaw, partialTicks, packedLight);
        this.poseStack.popPose();
        GL11.glEnable((int)2884);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    @Override
    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.pushPose();
        EntityLiving livingEntity = animatable instanceof EntityLiving ? (EntityLiving)animatable : null;
        boolean shouldSit = ((Entity)animatable).field_70154_o != null && ((Entity)animatable).field_70154_o.shouldRiderSit();
        float lerpBodyRot = livingEntity == null ? 0.0f : MathUtil.rotLerp(partialTick, livingEntity.field_70760_ar, livingEntity.field_70761_aq);
        float lerpHeadRot = livingEntity == null ? 0.0f : MathUtil.rotLerp(partialTick, livingEntity.field_70758_at, livingEntity.field_70759_as);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (shouldSit && ((Entity)animatable).field_70154_o instanceof EntityLiving) {
            EntityLiving livingentity = (EntityLiving)((Entity)animatable).field_70154_o;
            lerpBodyRot = MathUtil.rotLerp(partialTick, livingentity.field_70760_ar, livingentity.field_70761_aq);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = MathUtil.clamp(MathUtil.wrapDegrees(netHeadYaw), -85.0f, 85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        float ageInTicks = (float)((Entity)animatable).field_70173_aa + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!shouldSit && animatable.func_70089_S() && livingEntity != null) {
            limbSwingAmount = Math.min(1.0f, Interpolations.lerp(livingEntity.field_70722_aY, livingEntity.field_70721_aZ, partialTick));
            limbSwing = livingEntity.field_70754_ba - livingEntity.field_70721_aZ * (1.0f - partialTick);
            if (livingEntity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        if (!isReRender) {
            float headPitch = MathUtil.lerp(((Entity)animatable).field_70127_C, ((Entity)animatable).field_70125_A, partialTick);
            AnimationState<GeoAnimatable> animationState = new AnimationState<GeoAnimatable>((GeoAnimatable)animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAnimThreshold() || limbSwingAmount > this.getSwingMotionAnimThreshold());
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
            animationState.setData(DataTickets.ENTITY, animatable);
            animationState.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.func_70631_g_(), -netHeadYaw, -headPitch));
            this.model.addAdditionalStateData((Entity)((GeoAnimatable)animatable), instanceId, (BiConsumer<DataTicket<Entity>, Entity>)((BiConsumer<DataTicket, Entity>)(x$0, x$1) -> animationState.setData(x$0, x$1)));
            this.model.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        poseStack.translate(0.0f, 0.01f, 0.0f);
        this.modelRenderTranslations = new Matrix4f(poseStack.last().pose());
        GeoRenderer.super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.popPose();
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.15f;
    }

    @Override
    public void applyRenderLayers(PoseStack poseStack, T animatable, BakedGeoModel model, float partialTick, int packedLight, int packedOverlay) {
        GeoRenderer.super.applyRenderLayers(poseStack, (GeoAnimatable)animatable, model, partialTick, packedLight, packedOverlay);
    }

    @Override
    public void renderFinal(PoseStack poseStack, T animatable, BakedGeoModel model, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.pushPose();
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f(poseStack.last().pose());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.translateMatrix(localMatrix, this.getRenderOffset(this.animatable, 1.0f).toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtil.translateMatrix(new Matrix4f(localMatrix), new Vector3f((float)((Entity)animatable).field_70165_t, (float)((Entity)animatable).field_70163_u, (float)((Entity)animatable).field_70161_v)));
        }
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
        this.renderCubesOfBone(poseStack, bone, packedLight, packedOverlay, red, green, blue, alpha);
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, partialTick, packedLight, packedOverlay);
        }
        this.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.popPose();
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        EntityLiving livingEntity;
        EntityLiving entityLiving = livingEntity = animatable instanceof EntityLivingBase ? (EntityLiving)animatable : null;
        if (livingEntity == null || !livingEntity.func_70608_bn()) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        }
        if (livingEntity != null && livingEntity.field_70725_aQ > 0) {
            float deathRotation = ((float)livingEntity.field_70725_aQ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.mulPose(Axis.ZP.rotationDegrees(Math.min(MathUtil.sqrt(deathRotation), 1.0f) * this.getDeathMaxRotation(animatable)));
        } else if (livingEntity != null && livingEntity.func_70608_bn()) {
            poseStack.mulPose(Axis.YP.rotationDegrees(livingEntity instanceof EntityPlayer ? ((EntityPlayer)animatable).func_71051_bG() : rotationYaw));
            poseStack.mulPose(Axis.ZP.rotationDegrees(this.getDeathMaxRotation(animatable)));
            poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (animatable instanceof EntityLiving && ((EntityLiving)animatable).func_94056_bM() || animatable instanceof EntityPlayer) {
            String name = EnumChatFormatting.func_110646_a((String)animatable.func_70005_c_());
            if (animatable instanceof EntityPlayer) {
                if (((EntityPlayer)animatable).func_82238_cc()) {
                    return;
                }
            } else {
                name = EnumChatFormatting.func_110646_a((String)name);
            }
            if (name != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
                poseStack.translate(0.0f, ((Entity)animatable).field_70131_O + 0.1f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }

    public Vec3 getRenderOffset(T p_114483_, float p_114484_) {
        return Vec3.ZERO;
    }

    protected float getDeathMaxRotation(T animatable) {
        return 90.0f;
    }

    public int getPackedOverlay(T animatable, float u) {
        return 0;
    }

    @Override
    public int getPackedOverlay(T animatable, float u, float partialTick) {
        return this.getPackedOverlay(animatable, u);
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation(animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
    }

    @Override
    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, float partialTick, int packedLight) {
        return true;
    }

    @Override
    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, float partialTick, int packedLight) {
    }

    @Override
    public PoseStack applyTransform(PoseStack poseStack, T animatable) {
        return poseStack;
    }
}

