/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.renderer;

import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.forge.cache.object.BakedGeoModel;
import software.bernie.geckolib.forge.cache.object.GeoBone;
import software.bernie.geckolib.forge.cache.texture.AnimatableTexture;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.model.GeoModel;
import software.bernie.geckolib.forge.renderer.GeoRenderer;
import software.bernie.geckolib.forge.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.forge.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.forge.util.RenderUtil;
import software.bernie.geckolib.forge.util.mc.Axis;
import software.bernie.geckolib.forge.util.mc.PoseStack;
import software.bernie.libs.joml.Matrix4f;
import software.bernie.libs.joml.Vector3f;

public class GeoBlockRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer
implements GeoRenderer<T> {
    public PoseStack poseStack = new PoseStack();
    protected final GeoRenderLayersContainer<T> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Matrix4f blockRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeoBlockRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public T getAnimatable() {
        return this.animatable;
    }

    @Override
    public long getInstanceId(T animatable) {
        return ((long)((TileEntity)animatable).field_145848_d + (long)((TileEntity)animatable).field_145849_e * 31L) * 31L + (long)((TileEntity)animatable).field_145851_c;
    }

    @Override
    public List<GeoRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoBlockRenderer<T> addRenderLayer(GeoRenderLayer<T> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoBlockRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoBlockRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.blockRenderTranslations = new Matrix4f(poseStack.last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTick) {
        int packedLight;
        this.animatable = tile;
        World world = tile.func_145831_w();
        if (world != null) {
            Block block = world.func_147439_a((int)x, (int)y, (int)z);
            packedLight = world.func_72802_i((int)x, (int)y, (int)z, block.getLightValue((IBlockAccess)world, (int)x, (int)y, (int)z));
        } else {
            packedLight = 0xF000F0;
        }
        GL11.glDisable((int)2884);
        this.poseStack.pushPose();
        this.poseStack.translate(x, y, z);
        this.defaultRender(this.poseStack, (GeoAnimatable)this.animatable, 0.0f, partialTick, packedLight);
        this.poseStack.popPose();
        GL11.glEnable((int)2884);
    }

    @Override
    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender) {
            AnimationState<GeoAnimatable> animationState = new AnimationState<GeoAnimatable>((GeoAnimatable)animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
            animationState.setData(DataTickets.BLOCK_ENTITY, animatable);
            this.model.addAdditionalStateData((TileEntity)((GeoAnimatable)animatable), instanceId, (BiConsumer<DataTicket<TileEntity>, TileEntity>)((BiConsumer<DataTicket, TileEntity>)(x$0, x$1) -> animationState.setData(x$0, x$1)));
            poseStack.translate(0.5, 0.0, 0.5);
            this.rotateBlock(this.getFacing(animatable), poseStack);
            this.model.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f(poseStack.last().pose());
        GeoRenderer.super.actuallyRender(poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f(poseStack.last().pose());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, this.blockRenderTranslations);
            Matrix4f worldState = new Matrix4f(localMatrix);
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            bone.setWorldSpaceMatrix(worldState.translate(new Vector3f(((TileEntity)this.animatable).field_145851_c, ((TileEntity)this.animatable).field_145848_d, ((TileEntity)this.animatable).field_145849_e)));
        }
        GeoRenderer.super.renderRecursively(poseStack, (GeoAnimatable)animatable, bone, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected void rotateBlock(EnumFacing facing, PoseStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                break;
            }
            case UP: {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
            }
        }
    }

    public EnumFacing getFacing(T block) {
        return EnumFacing.NORTH;
    }

    @Override
    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((GeoAnimatable)animatable));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
    }

    @Override
    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, float partialTick, int packedLight) {
        return true;
    }

    @Override
    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, float partialTick, int packedLight) {
    }

    @Override
    public PoseStack applyTransform(PoseStack poseStack, T animatable) {
        return poseStack;
    }
}

