/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import software.bernie.geckolib.forge.animatable.GeoEntity;
import software.bernie.geckolib.forge.util.ClientUtil;

public class EntityAnimTriggerPacket<D>
implements IMessage,
IMessageHandler<EntityAnimTriggerPacket<D>, EntityAnimTriggerPacket<D>> {
    private int entityId;
    private boolean isReplacedEntity;
    private String controllerName;
    private String animName;

    public EntityAnimTriggerPacket() {
    }

    public EntityAnimTriggerPacket(int entityId, @Nullable String controllerName, String animName) {
        this(entityId, false, controllerName, animName);
    }

    public EntityAnimTriggerPacket(int entityId, boolean isReplacedEntity, @Nullable String controllerName, String animName) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.isReplacedEntity);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.controllerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.animName);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.isReplacedEntity = buf.readBoolean();
        this.controllerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.animName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public EntityAnimTriggerPacket<D> onMessage(EntityAnimTriggerPacket<D> packet, MessageContext messageContext) {
        Entity entity = ClientUtil.getLevel().func_73045_a(packet.entityId);
        if (entity == null) {
            return null;
        }
        if (entity instanceof GeoEntity) {
            ((GeoEntity)entity).triggerAnim(this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
        }
        return null;
    }
}

