/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import software.bernie.geckolib.forge.animatable.GeoEntity;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.network.SerializableDataTicket;
import software.bernie.geckolib.forge.util.ClientUtil;

public class EntityAnimDataSyncPacket<D>
implements IMessage,
IMessageHandler<EntityAnimDataSyncPacket<D>, EntityAnimDataSyncPacket<D>> {
    private int entityId;
    private SerializableDataTicket<D> dataTicket;
    private D data;

    public EntityAnimDataSyncPacket() {
    }

    public EntityAnimDataSyncPacket(int entityId, SerializableDataTicket<D> dataTicket, D data) {
        this.entityId = entityId;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.dataTicket = DataTickets.byName(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.dataTicket.decode(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dataTicket.id());
        this.dataTicket.encode(this.data, buf);
    }

    public EntityAnimDataSyncPacket<D> onMessage(EntityAnimDataSyncPacket<D> packet, MessageContext messageContext) {
        Entity entity = ClientUtil.getLevel().func_73045_a(packet.entityId);
        if (entity instanceof GeoEntity) {
            ((GeoEntity)entity).setAnimData(this.dataTicket, this.data);
        }
        return null;
    }
}

