/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import software.bernie.geckolib.forge.animatable.GeoBlockEntity;
import software.bernie.geckolib.forge.util.ClientUtil;

public class BlockEntityAnimTriggerPacket<D>
implements IMessage,
IMessageHandler<BlockEntityAnimTriggerPacket<D>, BlockEntityAnimTriggerPacket<D>> {
    private int xTile;
    private int yTile;
    private int zTile;
    private String controllerName;
    private String animName;

    public BlockEntityAnimTriggerPacket() {
    }

    public BlockEntityAnimTriggerPacket(int xTile, int yTile, int zTile, @Nullable String controllerName, String animName) {
        this.xTile = xTile;
        this.yTile = yTile;
        this.zTile = zTile;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    public void fromBytes(ByteBuf buf) {
        this.xTile = buf.readInt();
        this.yTile = buf.readInt();
        this.zTile = buf.readInt();
        this.controllerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.animName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xTile);
        buf.writeInt(this.yTile);
        buf.writeInt(this.zTile);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.controllerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.animName);
    }

    public BlockEntityAnimTriggerPacket<D> onMessage(BlockEntityAnimTriggerPacket<D> packet, MessageContext messageContext) {
        TileEntity blockEntity = ClientUtil.getLevel().func_147438_o(packet.xTile, packet.yTile, packet.zTile);
        if (blockEntity instanceof GeoBlockEntity) {
            ((GeoBlockEntity)blockEntity).triggerAnim(packet.controllerName.isEmpty() ? null : packet.controllerName, packet.animName);
        }
        return null;
    }
}

