/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import software.bernie.geckolib.forge.animatable.GeoBlockEntity;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.network.SerializableDataTicket;
import software.bernie.geckolib.forge.util.ClientUtil;

public class BlockEntityAnimDataSyncPacket<D>
implements IMessage,
IMessageHandler<BlockEntityAnimDataSyncPacket<D>, BlockEntityAnimDataSyncPacket<D>> {
    private int xTile;
    private int yTile;
    private int zTile;
    private SerializableDataTicket<D> dataTicket;
    private D data;

    public BlockEntityAnimDataSyncPacket() {
    }

    public BlockEntityAnimDataSyncPacket(int xTile, int yTile, int zTile, SerializableDataTicket<D> dataTicket, D data) {
        this.xTile = xTile;
        this.yTile = yTile;
        this.zTile = zTile;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.xTile = buf.readInt();
        this.yTile = buf.readInt();
        this.zTile = buf.readInt();
        this.dataTicket = DataTickets.byName(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.dataTicket.decode(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xTile);
        buf.writeInt(this.yTile);
        buf.writeInt(this.zTile);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dataTicket.id());
    }

    public BlockEntityAnimDataSyncPacket<D> onMessage(BlockEntityAnimDataSyncPacket<D> packet, MessageContext messageContext) {
        TileEntity blockEntity = ClientUtil.getLevel().func_147438_o(packet.xTile, packet.yTile, packet.zTile);
        if (blockEntity instanceof GeoBlockEntity) {
            ((GeoBlockEntity)blockEntity).setAnimData(this.dataTicket, this.data);
        }
        return null;
    }
}

