/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.forge.network.GeckoLibNetwork;

public class AnimTriggerPacket<D>
implements IMessage,
IMessageHandler<AnimTriggerPacket<D>, AnimTriggerPacket<D>> {
    private String syncableId;
    private long instanceId;
    private String controllerName;
    private String animName;

    public AnimTriggerPacket() {
    }

    public AnimTriggerPacket(String syncableId, long instanceId, @Nullable String controllerName, String animName) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    public void fromBytes(ByteBuf buf) {
        this.syncableId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.instanceId = buf.readLong();
        this.controllerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.animName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.syncableId);
        buf.writeLong(this.instanceId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.controllerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.animName);
    }

    public AnimTriggerPacket<D> onMessage(AnimTriggerPacket<D> packet, MessageContext context) {
        GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(packet.syncableId);
        if (animatable != null) {
            AnimatableManager manager = animatable.getAnimatableInstanceCache().getManagerForId(packet.instanceId);
            manager.tryTriggerAnimation(packet.controllerName, packet.animName);
        }
        return null;
    }
}

