/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.network.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.forge.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.network.GeckoLibNetwork;
import software.bernie.geckolib.forge.network.SerializableDataTicket;
import software.bernie.geckolib.forge.util.ClientUtil;

public class AnimDataSyncPacket<D>
implements IMessage,
IMessageHandler<AnimDataSyncPacket<D>, AnimDataSyncPacket<D>> {
    private String syncableId;
    private long instanceId;
    private SerializableDataTicket<D> dataTicket;
    private D data;

    public AnimDataSyncPacket() {
    }

    public AnimDataSyncPacket(String syncableId, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        this.syncableId = syncableId;
        this.instanceId = instanceId;
        this.dataTicket = dataTicket;
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        this.syncableId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.instanceId = buf.readLong();
        SerializableDataTicket<?> dataTicket = DataTickets.byName(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.data = dataTicket.decode(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.syncableId);
        buf.writeLong(this.instanceId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.dataTicket.id());
        this.dataTicket.encode(this.data, buf);
    }

    public AnimDataSyncPacket<D> onMessage(AnimDataSyncPacket<D> packet, MessageContext context) {
        GeoAnimatable animatable = GeckoLibNetwork.getSyncedAnimatable(packet.syncableId);
        if (animatable instanceof SingletonGeoAnimatable) {
            ((SingletonGeoAnimatable)animatable).setAnimData((Entity)ClientUtil.getClientPlayer(), packet.instanceId, packet.dataTicket, packet.data);
        }
        return null;
    }
}

