/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.forge.GeckoLib;
import software.bernie.geckolib.forge.network.packet.AnimDataSyncPacket;
import software.bernie.geckolib.forge.network.packet.AnimTriggerPacket;
import software.bernie.geckolib.forge.network.packet.BlockEntityAnimDataSyncPacket;
import software.bernie.geckolib.forge.network.packet.BlockEntityAnimTriggerPacket;
import software.bernie.geckolib.forge.network.packet.EntityAnimDataSyncPacket;
import software.bernie.geckolib.forge.network.packet.EntityAnimTriggerPacket;

public final class GeckoLibNetwork {
    private static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("geckolib_main");
    private static final Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap<String, GeoAnimatable>();

    public static void onInit() {
        int packetId = 0;
        NETWORK.registerMessage(new AnimDataSyncPacket(), AnimDataSyncPacket.class, packetId++, Side.CLIENT);
        NETWORK.registerMessage(new AnimTriggerPacket(), AnimTriggerPacket.class, packetId++, Side.CLIENT);
        NETWORK.registerMessage(new BlockEntityAnimDataSyncPacket(), BlockEntityAnimDataSyncPacket.class, packetId++, Side.CLIENT);
        NETWORK.registerMessage(new BlockEntityAnimTriggerPacket(), BlockEntityAnimTriggerPacket.class, packetId++, Side.CLIENT);
        NETWORK.registerMessage(new EntityAnimDataSyncPacket(), EntityAnimDataSyncPacket.class, packetId++, Side.CLIENT);
        NETWORK.registerMessage(new EntityAnimTriggerPacket(), EntityAnimTriggerPacket.class, packetId++, Side.CLIENT);
    }

    public static synchronized void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeoAnimatable existing = SYNCED_ANIMATABLES.put(animatable.getSyncableId(), animatable);
        if (existing == null) {
            GeckoLib.LOGGER.debug("Registered SyncedAnimatable for " + animatable.getSyncableId());
        }
    }

    @Nullable
    public static GeoAnimatable getSyncedAnimatable(String className) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(className);
        if (animatable == null) {
            GeckoLib.LOGGER.error("Attempting to retrieve unregistered synced animatable! (" + className + ")");
        }
        return animatable;
    }

    public static <M> void send(IMessage packet, Entity entity) {
        EntityTracker tracker = ((WorldServer)entity.field_70170_p).func_73039_n();
        for (EntityPlayer other : tracker.getTrackingPlayers(entity)) {
            NETWORK.sendTo(packet, (EntityPlayerMP)other);
        }
        if (entity instanceof EntityPlayerMP) {
            NETWORK.sendTo(packet, (EntityPlayerMP)entity);
        }
    }

    public static <M> void send(IMessage packet, World level, int x, int y, int z, int range) {
        NETWORK.sendToAllAround(packet, new NetworkRegistry.TargetPoint(level.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, (double)range));
    }
}

