/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoModel;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.forge.GeckoLibException;
import software.bernie.geckolib.forge.cache.GeckoLibCache;
import software.bernie.geckolib.forge.cache.object.BakedGeoModel;
import software.bernie.geckolib.forge.cache.object.GeoBone;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.loading.object.BakedAnimations;
import software.bernie.geckolib.forge.util.RenderUtil;

public abstract class GeoModel<T extends GeoAnimatable>
implements CoreGeoModel<T> {
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    private BakedGeoModel currentModel = null;
    private double animTime;
    private double lastGameTickTime;

    public abstract ResourceLocation getModelResource(T var1);

    public abstract ResourceLocation getTextureResource(T var1);

    public abstract ResourceLocation getAnimationResource(T var1);

    public abstract ResourceLocation getTransformsResource(T var1);

    public boolean crashIfBoneMissing() {
        return false;
    }

    @Override
    public final BakedGeoModel getBakedGeoModel(String location) {
        return this.getBakedModel(new ResourceLocation(location));
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        BakedGeoModel model = GeckoLibCache.getBakedModels().get(location);
        if (model == null) {
            throw new GeckoLibException(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.processor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    @Override
    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable((GeoBone)this.getAnimationProcessor().getBone(name));
    }

    @Override
    public Animation getAnimation(T animatable, String name) {
        ResourceLocation location = this.getAnimationResource(animatable);
        BakedAnimations bakedAnimations = GeckoLibCache.getBakedAnimations().get(location);
        if (bakedAnimations == null) {
            throw new GeckoLibException(location, "Unable to find animation.");
        }
        return bakedAnimations.getAnimation(name);
    }

    @Override
    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(T animatable, long instanceId, BiConsumer<DataTicket<T>, T> dataConsumer) {
    }

    @Override
    public final void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        Minecraft mc = Minecraft.func_71410_x();
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            currentTick = animatable instanceof Entity ? (double)((Entity)animatable).field_70173_aa : RenderUtil.getCurrentTick();
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)RenderUtil.getFrameTime());
        }
        if (!mc.func_147113_T() || animatable.shouldPlayAnimsWhileGamePaused()) {
            animatableManager.updatedAt(animatable instanceof Entity ? currentTick + (double)RenderUtil.getFrameTime() : currentTick - animatableManager.getFirstTickTime());
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        animationState.animationTick = this.animTime;
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        processor.preAnimationSetup(animationState.getAnimatable(), this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, this, animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations(animatable, instanceId, animationState);
    }

    @Override
    public void applyMolangQueries(T animatable, double animTime) {
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft mc = Minecraft.func_71410_x();
        parser.setMemoizedValue("query.life_time", () -> animTime / 20.0);
        parser.setMemoizedValue("query.actor_count", () -> mc.field_71441_e.field_73010_i.size());
        parser.setMemoizedValue("query.time_of_day", () -> (float)mc.field_71441_e.func_72820_D() / 24000.0f);
        parser.setMemoizedValue("query.moon_phase", () -> ((WorldClient)mc.field_71441_e).func_72853_d());
        if (animatable instanceof Entity) {
            Entity entity = (Entity)animatable;
            parser.setMemoizedValue("query.distance_from_camera", () -> mc.field_71439_g.func_70032_d(entity));
            parser.setMemoizedValue("query.is_on_ground", () -> RenderUtil.booleanToFloat(entity.field_70122_E));
            parser.setMemoizedValue("query.is_in_water", () -> RenderUtil.booleanToFloat(entity.func_70090_H()));
            parser.setMemoizedValue("query.is_in_water_or_rain", () -> RenderUtil.booleanToFloat(entity.func_70026_G()));
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                parser.setMemoizedValue("query.health", () -> ((EntityLiving)livingEntity).func_110143_aJ());
                parser.setMemoizedValue("query.max_health", () -> ((EntityLiving)livingEntity).func_110138_aP());
                parser.setMemoizedValue("query.is_on_fire", () -> RenderUtil.booleanToFloat(livingEntity.func_70027_ad()));
                parser.setMemoizedValue("query.ground_speed", () -> {
                    Vec3 velocity = Vec3.func_72443_a((double)livingEntity.field_70159_w, (double)livingEntity.field_70181_x, (double)livingEntity.field_70179_y);
                    return Math.sqrt((float)(velocity.field_72450_a * velocity.field_72450_a + velocity.field_72449_c * velocity.field_72449_c));
                });
                parser.setMemoizedValue("query.yaw_speed", () -> this.getViewYRot((Entity)livingEntity, (float)animTime - this.getViewYRot((Entity)livingEntity, (float)animTime - 0.1f)));
            }
        }
    }

    public float getViewYRot(Entity entity, float p_20279_) {
        return p_20279_ == 1.0f ? entity.field_70177_z : GeoModel.lerp(p_20279_, entity.field_70126_B, entity.field_70177_z);
    }

    public static float lerp(float p_14180_, float p_14181_, float p_14182_) {
        return p_14181_ + p_14180_ * (p_14182_ - p_14181_);
    }
}

