/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.model;

import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.forge.model.GeoModel;

public abstract class DefaultedGeoModel<T extends GeoAnimatable>
extends GeoModel<T> {
    private ResourceLocation modelPath;
    private ResourceLocation texturePath;
    private ResourceLocation animationsPath;

    public DefaultedGeoModel(ResourceLocation assetSubpath) {
        this.modelPath = this.buildFormattedModelPath(assetSubpath);
        this.texturePath = this.buildFormattedTexturePath(assetSubpath);
        this.animationsPath = this.buildFormattedAnimationPath(assetSubpath);
    }

    public DefaultedGeoModel<T> withAltModel(ResourceLocation altPath) {
        this.modelPath = this.buildFormattedModelPath(altPath);
        return this;
    }

    public DefaultedGeoModel<T> withAltAnimations(ResourceLocation altPath) {
        this.animationsPath = this.buildFormattedAnimationPath(altPath);
        return this;
    }

    public DefaultedGeoModel<T> withAltTexture(ResourceLocation altPath) {
        this.texturePath = this.buildFormattedTexturePath(altPath);
        return this;
    }

    public ResourceLocation buildFormattedModelPath(ResourceLocation basePath) {
        return new ResourceLocation(basePath.func_110624_b(), "geo/" + this.subtype() + "/" + basePath.func_110623_a() + ".geo.json");
    }

    public ResourceLocation buildFormattedAnimationPath(ResourceLocation basePath) {
        return new ResourceLocation(basePath.func_110624_b(), "animations/" + this.subtype() + "/" + basePath.func_110623_a() + ".animation.json");
    }

    public ResourceLocation buildFormattedTexturePath(ResourceLocation basePath) {
        return new ResourceLocation(basePath.func_110624_b(), "textures/models/" + this.subtype() + "/" + basePath.func_110623_a() + ".png");
    }

    protected abstract String subtype();

    @Override
    public ResourceLocation getModelResource(T animatable) {
        return this.modelPath;
    }

    @Override
    public ResourceLocation getTextureResource(T animatable) {
        return this.texturePath;
    }

    @Override
    public ResourceLocation getAnimationResource(T animatable) {
        return this.animationsPath;
    }

    @Override
    public ResourceLocation getTransformsResource(T animatable) {
        return null;
    }
}

