/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.model;

import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.forge.constant.DataTickets;
import software.bernie.geckolib.forge.model.DefaultedGeoModel;
import software.bernie.geckolib.forge.model.data.EntityModelData;

public class DefaultedEntityGeoModel<T extends GeoAnimatable>
extends DefaultedGeoModel<T> {
    private final boolean turnsHead;

    public DefaultedEntityGeoModel(ResourceLocation assetSubpath) {
        this(assetSubpath, false);
    }

    public DefaultedEntityGeoModel(ResourceLocation assetSubpath, boolean turnsHead) {
        super(assetSubpath);
        this.turnsHead = turnsHead;
    }

    @Override
    protected String subtype() {
        return "entity";
    }

    @Override
    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        if (!this.turnsHead) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltModel(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltModel(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltAnimations(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltAnimations(altPath);
    }

    @Override
    public DefaultedEntityGeoModel<T> withAltTexture(ResourceLocation altPath) {
        return (DefaultedEntityGeoModel)super.withAltTexture(altPath);
    }
}

