/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import software.bernie.geckolib.forge.loading.json.raw.Bone;
import software.bernie.geckolib.forge.loading.json.raw.MinecraftGeometry;
import software.bernie.geckolib.forge.loading.json.raw.Model;
import software.bernie.geckolib.forge.loading.json.raw.ModelProperties;
import software.bernie.geckolib.forge.loading.object.BoneStructure;

public class GeometryTree {
    private final Map<String, BoneStructure> topLevelBones;
    private final ModelProperties properties;

    public GeometryTree(Map<String, BoneStructure> topLevelBones, ModelProperties properties) {
        this.topLevelBones = topLevelBones;
        this.properties = properties;
    }

    public Map<String, BoneStructure> topLevelBones() {
        return this.topLevelBones;
    }

    public ModelProperties properties() {
        return this.properties;
    }

    public static GeometryTree fromModel(Model model) {
        Object2ObjectOpenHashMap<String, BoneStructure> topLevelBones = new Object2ObjectOpenHashMap<String, BoneStructure>();
        MinecraftGeometry geometry = model.minecraftGeometry()[0];
        ObjectArrayList<Bone> bones = new ObjectArrayList<Bone>(geometry.bones());
        int index = bones.size() - 1;
        while (true) {
            Bone bone;
            if ((bone = (Bone)bones.get(index)).parent() == null) {
                topLevelBones.put(bone.name(), new BoneStructure(bone));
                bones.remove(index);
            } else {
                BoneStructure structure = GeometryTree.findBoneStructureInTree(topLevelBones, bone.parent());
                if (structure != null) {
                    structure.children().put(bone.name(), new BoneStructure(bone));
                    bones.remove(index);
                }
            }
            if (index == 0) {
                index = bones.size() - 1;
                if (index != -1) continue;
                break;
            }
            --index;
        }
        return new GeometryTree(topLevelBones, geometry.modelProperties());
    }

    private static BoneStructure findBoneStructureInTree(Map<String, BoneStructure> bones, String boneName) {
        for (BoneStructure entry : bones.values()) {
            if (boneName.equals(entry.self().name())) {
                return entry;
            }
            BoneStructure subStructure = GeometryTree.findBoneStructureInTree(entry.children(), boneName);
            if (subStructure == null) continue;
            return subStructure;
        }
        return null;
    }
}

