/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.object;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import software.bernie.geckolib.forge.cache.object.BakedGeoModel;
import software.bernie.geckolib.forge.cache.object.GeoBone;
import software.bernie.geckolib.forge.cache.object.GeoCube;
import software.bernie.geckolib.forge.cache.object.GeoQuad;
import software.bernie.geckolib.forge.cache.object.GeoVertex;
import software.bernie.geckolib.forge.loading.json.raw.Bone;
import software.bernie.geckolib.forge.loading.json.raw.Cube;
import software.bernie.geckolib.forge.loading.json.raw.FaceUV;
import software.bernie.geckolib.forge.loading.json.raw.ModelProperties;
import software.bernie.geckolib.forge.loading.json.raw.UVUnion;
import software.bernie.geckolib.forge.loading.object.BoneStructure;
import software.bernie.geckolib.forge.loading.object.GeometryTree;
import software.bernie.geckolib.forge.util.RenderUtil;
import software.bernie.geckolib.forge.util.mc.Vec3;

public interface BakedModelFactory {
    public static final Map<String, BakedModelFactory> FACTORIES = new Object2ObjectOpenHashMap<String, BakedModelFactory>(1);
    public static final BakedModelFactory DEFAULT_FACTORY = new Builtin();

    public BakedGeoModel constructGeoModel(GeometryTree var1);

    public GeoBone constructBone(BoneStructure var1, ModelProperties var2, @Nullable GeoBone var3);

    public GeoCube constructCube(Cube var1, ModelProperties var2, GeoBone var3);

    default public GeoQuad[] buildQuads(UVUnion uvUnion, VertexSet vertices, Cube cube, float textureWidth, float textureHeight, boolean mirror) {
        GeoQuad[] quads = new GeoQuad[]{this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, EnumFacing.WEST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, EnumFacing.EAST), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, EnumFacing.NORTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, EnumFacing.SOUTH), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, EnumFacing.UP), this.buildQuad(vertices, cube, uvUnion, textureWidth, textureHeight, mirror, EnumFacing.DOWN)};
        return quads;
    }

    default public GeoQuad buildQuad(VertexSet vertices, Cube cube, UVUnion uvUnion, float textureWidth, float textureHeight, boolean mirror, EnumFacing direction) {
        if (!uvUnion.isBoxUV()) {
            FaceUV faceUV = uvUnion.faceUV().fromDirection(direction);
            if (faceUV == null) {
                return null;
            }
            return GeoQuad.build(vertices.verticesForQuad(direction, false, mirror || cube.mirror() == Boolean.TRUE), faceUV.uv(), faceUV.uvSize(), textureWidth, textureHeight, mirror, direction);
        }
        double[] uv = cube.uv().boxUVCoords();
        double[] uvSize = cube.size();
        Vec3 uvSizeVec = new Vec3(Math.floor(uvSize[0]), Math.floor(uvSize[1]), Math.floor(uvSize[2]));
        double[][] uvData = new double[][]{};
        switch (direction) {
            case WEST: {
                uvData = new double[][]{{uv[0] + uvSizeVec.z + uvSizeVec.x, uv[1] + uvSizeVec.z}, {uvSizeVec.z, uvSizeVec.y}};
                break;
            }
            case EAST: {
                uvData = new double[][]{{uv[0], uv[1] + uvSizeVec.z}, {uvSizeVec.z, uvSizeVec.y}};
                break;
            }
            case NORTH: {
                uvData = new double[][]{{uv[0] + uvSizeVec.z, uv[1] + uvSizeVec.z}, {uvSizeVec.x, uvSizeVec.y}};
                break;
            }
            case SOUTH: {
                uvData = new double[][]{{uv[0] + uvSizeVec.z + uvSizeVec.x + uvSizeVec.z, uv[1] + uvSizeVec.z}, {uvSizeVec.x, uvSizeVec.y}};
                break;
            }
            case UP: {
                uvData = new double[][]{{uv[0] + uvSizeVec.z, uv[1]}, {uvSizeVec.x, uvSizeVec.z}};
                break;
            }
            case DOWN: {
                uvData = new double[][]{{uv[0] + uvSizeVec.z + uvSizeVec.x, uv[1] + uvSizeVec.z}, {uvSizeVec.x, -uvSizeVec.z}};
            }
        }
        return GeoQuad.build(vertices.verticesForQuad(direction, true, mirror || cube.mirror() == Boolean.TRUE), uvData[0], uvData[1], textureWidth, textureHeight, mirror, direction);
    }

    public static BakedModelFactory getForNamespace(String namespace) {
        return FACTORIES.getOrDefault(namespace, DEFAULT_FACTORY);
    }

    public static void register(String namespace, BakedModelFactory factory) {
        FACTORIES.put(namespace, factory);
    }

    public static class VertexSet {
        private final GeoVertex bottomLeftBack;
        private final GeoVertex bottomRightBack;
        private final GeoVertex topLeftBack;
        private final GeoVertex topRightBack;
        private final GeoVertex topLeftFront;
        private final GeoVertex topRightFront;
        private final GeoVertex bottomLeftFront;
        private final GeoVertex bottomRightFront;

        public VertexSet(GeoVertex bottomLeftBack, GeoVertex bottomRightBack, GeoVertex topLeftBack, GeoVertex topRightBack, GeoVertex topLeftFront, GeoVertex topRightFront, GeoVertex bottomLeftFront, GeoVertex bottomRightFront) {
            this.bottomLeftBack = bottomLeftBack;
            this.bottomRightBack = bottomRightBack;
            this.topLeftBack = topLeftBack;
            this.topRightBack = topRightBack;
            this.topLeftFront = topLeftFront;
            this.topRightFront = topRightFront;
            this.bottomLeftFront = bottomLeftFront;
            this.bottomRightFront = bottomRightFront;
        }

        public VertexSet(Vec3 origin, Vec3 vertexSize, double inflation) {
            this(new GeoVertex(origin.x - inflation, origin.y - inflation, origin.z - inflation), new GeoVertex(origin.x - inflation, origin.y - inflation, origin.z + vertexSize.z + inflation), new GeoVertex(origin.x - inflation, origin.y + vertexSize.y + inflation, origin.z - inflation), new GeoVertex(origin.x - inflation, origin.y + vertexSize.y + inflation, origin.z + vertexSize.z + inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y + vertexSize.y + inflation, origin.z - inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y + vertexSize.y + inflation, origin.z + vertexSize.z + inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y - inflation, origin.z - inflation), new GeoVertex(origin.x + vertexSize.x + inflation, origin.y - inflation, origin.z + vertexSize.z + inflation));
        }

        public GeoVertex[] quadWest() {
            return new GeoVertex[]{this.topRightBack, this.topLeftBack, this.bottomLeftBack, this.bottomRightBack};
        }

        public GeoVertex[] quadEast() {
            return new GeoVertex[]{this.topLeftFront, this.topRightFront, this.bottomRightFront, this.bottomLeftFront};
        }

        public GeoVertex[] quadNorth() {
            return new GeoVertex[]{this.topLeftBack, this.topLeftFront, this.bottomLeftFront, this.bottomLeftBack};
        }

        public GeoVertex[] quadSouth() {
            return new GeoVertex[]{this.topRightFront, this.topRightBack, this.bottomRightBack, this.bottomRightFront};
        }

        public GeoVertex[] quadUp() {
            return new GeoVertex[]{this.topRightBack, this.topRightFront, this.topLeftFront, this.topLeftBack};
        }

        public GeoVertex[] quadDown() {
            return new GeoVertex[]{this.bottomLeftBack, this.bottomLeftFront, this.bottomRightFront, this.bottomRightBack};
        }

        public GeoVertex[] verticesForQuad(EnumFacing direction, boolean boxUv, boolean mirror) {
            switch (direction) {
                case WEST: {
                    return mirror ? this.quadEast() : this.quadWest();
                }
                case EAST: {
                    return mirror ? this.quadWest() : this.quadEast();
                }
                case NORTH: {
                    return this.quadNorth();
                }
                case SOUTH: {
                    return this.quadSouth();
                }
                case UP: {
                    return mirror && !boxUv ? this.quadDown() : this.quadUp();
                }
                case DOWN: {
                    return mirror && !boxUv ? this.quadUp() : this.quadDown();
                }
            }
            return null;
        }
    }

    public static final class Builtin
    implements BakedModelFactory {
        @Override
        public BakedGeoModel constructGeoModel(GeometryTree geometryTree) {
            ObjectArrayList<GeoBone> bones = new ObjectArrayList<GeoBone>();
            for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
                bones.add(this.constructBone(boneStructure, geometryTree.properties(), null));
            }
            return new BakedGeoModel(bones, geometryTree.properties());
        }

        @Override
        public GeoBone constructBone(BoneStructure boneStructure, ModelProperties properties, GeoBone parent) {
            Bone bone = boneStructure.self();
            GeoBone newBone = new GeoBone(parent, bone.name(), bone.mirror(), bone.inflate(), bone.neverRender(), bone.reset());
            Vec3 rotation = RenderUtil.arrayToVec(bone.rotation());
            Vec3 pivot = RenderUtil.arrayToVec(bone.pivot());
            newBone.updateRotation((float)Math.toRadians(-rotation.x), (float)Math.toRadians(-rotation.y), (float)Math.toRadians(rotation.z));
            newBone.updatePivot((float)(-pivot.x), (float)pivot.y, (float)pivot.z);
            for (Cube cube : bone.cubes()) {
                newBone.getCubes().add(this.constructCube(cube, properties, newBone));
            }
            for (BoneStructure child : boneStructure.children().values()) {
                newBone.getChildBones().add(this.constructBone(child, properties, newBone));
            }
            return newBone;
        }

        @Override
        public GeoCube constructCube(Cube cube, ModelProperties properties, GeoBone bone) {
            boolean mirror;
            boolean bl = mirror = cube.mirror() == Boolean.TRUE;
            double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
            Vec3 size = RenderUtil.arrayToVec(cube.size());
            Vec3 origin = RenderUtil.arrayToVec(cube.origin());
            Vec3 rotation = RenderUtil.arrayToVec(cube.rotation());
            Vec3 pivot = RenderUtil.arrayToVec(cube.pivot());
            origin = new Vec3(-(origin.x + size.x) / 16.0, origin.y / 16.0, origin.z / 16.0);
            Vec3 vertexSize = size.multiply(0.0625, 0.0625, 0.0625);
            pivot = pivot.multiply(-1.0, 1.0, 1.0);
            rotation = new Vec3(Math.toRadians(-rotation.x), Math.toRadians(-rotation.y), Math.toRadians(rotation.z));
            GeoQuad[] quads = this.buildQuads(cube.uv(), new VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
            return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
        }
    }
}

