/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.typeadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.Map;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.core.keyframe.event.data.ParticleKeyframeData;
import software.bernie.geckolib.core.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class KeyFramesAdapter
implements JsonDeserializer<Animation.Keyframes> {
    public Animation.Keyframes deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        SoundKeyframeData[] sounds = KeyFramesAdapter.buildSoundFrameData(obj);
        ParticleKeyframeData[] particles = KeyFramesAdapter.buildParticleFrameData(obj);
        CustomInstructionKeyframeData[] customInstructions = KeyFramesAdapter.buildCustomFrameData(obj);
        return new Animation.Keyframes(sounds, particles, customInstructions);
    }

    private static SoundKeyframeData[] buildSoundFrameData(JsonObject rootObj) {
        JsonObject soundsObj = GsonHelper.getAsJsonObject(rootObj, "sound_effects", new JsonObject());
        SoundKeyframeData[] sounds = new SoundKeyframeData[soundsObj.entrySet().size()];
        int index = 0;
        for (Map.Entry entry : soundsObj.entrySet()) {
            sounds[index] = new SoundKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, GsonHelper.getAsString(((JsonElement)entry.getValue()).getAsJsonObject(), "effect"));
            ++index;
        }
        return sounds;
    }

    private static ParticleKeyframeData[] buildParticleFrameData(JsonObject rootObj) {
        JsonObject particlesObj = GsonHelper.getAsJsonObject(rootObj, "particle_effects", new JsonObject());
        ParticleKeyframeData[] particles = new ParticleKeyframeData[particlesObj.entrySet().size()];
        int index = 0;
        for (Map.Entry entry : particlesObj.entrySet()) {
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            String effect = GsonHelper.getAsString(obj, "effect", "");
            String locator = GsonHelper.getAsString(obj, "locator", "");
            String script = GsonHelper.getAsString(obj, "pre_effect_script", "");
            particles[index] = new ParticleKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, effect, locator, script);
            ++index;
        }
        return particles;
    }

    private static CustomInstructionKeyframeData[] buildCustomFrameData(JsonObject rootObj) {
        JsonObject customInstructionsObj = GsonHelper.getAsJsonObject(rootObj, "timeline", new JsonObject());
        CustomInstructionKeyframeData[] customInstructions = new CustomInstructionKeyframeData[customInstructionsObj.entrySet().size()];
        int index = 0;
        for (Map.Entry entry : customInstructionsObj.entrySet()) {
            String instructions = "";
            if (entry.getValue() instanceof JsonArray) {
                JsonArray array = (JsonArray)entry.getValue();
                instructions = ((ObjectArrayList)JsonUtil.GEO_GSON.fromJson((JsonElement)array, ObjectArrayList.class)).toString();
            } else if (entry.getValue() instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)entry.getValue();
                instructions = primitive.getAsString();
            }
            customInstructions[index] = new CustomInstructionKeyframeData(Double.parseDouble((String)entry.getKey()) * 20.0, instructions);
            ++index;
        }
        return customInstructions;
    }
}

