/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import software.bernie.geckolib.forge.loading.json.raw.FaceUV;
import software.bernie.geckolib.forge.util.GsonHelper;

public class UVFaces {
    @Nullable
    private final FaceUV north;
    @Nullable
    private final FaceUV south;
    @Nullable
    private final FaceUV east;
    @Nullable
    private final FaceUV west;
    @Nullable
    private final FaceUV up;
    @Nullable
    private final FaceUV down;

    public UVFaces(@Nullable FaceUV north, @Nullable FaceUV south, @Nullable FaceUV east, @Nullable FaceUV west, @Nullable FaceUV up, @Nullable FaceUV down) {
        this.north = north;
        this.south = south;
        this.east = east;
        this.west = west;
        this.up = up;
        this.down = down;
    }

    public static JsonDeserializer<UVFaces> deserializer() {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            FaceUV north = GsonHelper.getAsObject(obj, "north", null, context, FaceUV.class);
            FaceUV south = GsonHelper.getAsObject(obj, "south", null, context, FaceUV.class);
            FaceUV east = GsonHelper.getAsObject(obj, "east", null, context, FaceUV.class);
            FaceUV west = GsonHelper.getAsObject(obj, "west", null, context, FaceUV.class);
            FaceUV up = GsonHelper.getAsObject(obj, "up", null, context, FaceUV.class);
            FaceUV down = GsonHelper.getAsObject(obj, "down", null, context, FaceUV.class);
            return new UVFaces(north, south, east, west, up, down);
        };
    }

    public FaceUV fromDirection(EnumFacing direction) {
        switch (direction) {
            case NORTH: {
                return this.north;
            }
            case SOUTH: {
                return this.south;
            }
            case EAST: {
                return this.east;
            }
            case WEST: {
                return this.west;
            }
            default: {
                return this.up;
            }
            case DOWN: 
        }
        return this.down;
    }

    @Nullable
    public FaceUV north() {
        return this.north;
    }

    @Nullable
    public FaceUV south() {
        return this.south;
    }

    @Nullable
    public FaceUV east() {
        return this.east;
    }

    @Nullable
    public FaceUV west() {
        return this.west;
    }

    @Nullable
    public FaceUV up() {
        return this.up;
    }

    @Nullable
    public FaceUV down() {
        return this.down;
    }
}

