/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import software.bernie.geckolib.forge.loading.json.raw.PolysUnion;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class PolyMesh {
    @Nullable
    private final Boolean normalizedUVs;
    private final double[] normals;
    @Nullable
    private final PolysUnion polysUnion;
    private final double[] positions;
    private final double[] uvs;

    public PolyMesh(@Nullable Boolean normalizedUVs, double[] normals, @Nullable PolysUnion polysUnion, double[] positions, double[] uvs) {
        this.normalizedUVs = normalizedUVs;
        this.normals = normals;
        this.polysUnion = polysUnion;
        this.positions = positions;
        this.uvs = uvs;
    }

    public static JsonDeserializer<PolyMesh> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Boolean normalizedUVs = JsonUtil.getOptionalBoolean(obj, "normalized_uvs");
            double[] normals = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "normals", null));
            PolysUnion polysUnion = GsonHelper.getAsObject(obj, "polys", null, context, PolysUnion.class);
            double[] positions = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "positions", null));
            double[] uvs = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "uvs", null));
            return new PolyMesh(normalizedUVs, normals, polysUnion, positions, uvs);
        };
    }

    @Nullable
    public Boolean normalizedUVs() {
        return this.normalizedUVs;
    }

    public double[] normals() {
        return this.normals;
    }

    @Nullable
    public PolysUnion polysUnion() {
        return this.polysUnion;
    }

    public double[] positions() {
        return this.positions;
    }

    public double[] uvs() {
        return this.uvs;
    }
}

