/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import software.bernie.geckolib.forge.loading.json.FormatVersion;
import software.bernie.geckolib.forge.loading.json.raw.MinecraftGeometry;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class Model {
    @Nullable
    private final FormatVersion formatVersion;
    private final MinecraftGeometry[] minecraftGeometry;

    public Model(@Nullable FormatVersion formatVersion, MinecraftGeometry[] minecraftGeometry) {
        this.formatVersion = formatVersion;
        this.minecraftGeometry = minecraftGeometry;
    }

    public static JsonDeserializer<Model> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            FormatVersion formatVersion = (FormatVersion)((Object)((Object)context.deserialize(obj.get("format_version"), FormatVersion.class)));
            MinecraftGeometry[] minecraftGeometry = JsonUtil.jsonArrayToObjectArray(GsonHelper.getAsJsonArray(obj, "minecraft:geometry", new JsonArray()), context, MinecraftGeometry.class);
            return new Model(formatVersion, minecraftGeometry);
        };
    }

    @Nullable
    public FormatVersion formatVersion() {
        return this.formatVersion;
    }

    public MinecraftGeometry[] minecraftGeometry() {
        return this.minecraftGeometry;
    }
}

