/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import software.bernie.geckolib.forge.loading.json.raw.Bone;
import software.bernie.geckolib.forge.loading.json.raw.ModelProperties;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class MinecraftGeometry {
    private final Bone[] bones;
    @Nullable
    private final String cape;
    @Nullable
    private final ModelProperties modelProperties;

    public MinecraftGeometry(Bone[] bones, @Nullable String cape, @Nullable ModelProperties modelProperties) {
        this.bones = bones;
        this.cape = cape;
        this.modelProperties = modelProperties;
    }

    public static JsonDeserializer<MinecraftGeometry> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Bone[] bones = JsonUtil.jsonArrayToObjectArray(GsonHelper.getAsJsonArray(obj, "bones", new JsonArray()), context, Bone.class);
            String cape = GsonHelper.getAsString(obj, "cape", null);
            ModelProperties modelProperties = GsonHelper.getAsObject(obj, "description", null, context, ModelProperties.class);
            return new MinecraftGeometry(bones, cape, modelProperties);
        };
    }

    public Bone[] bones() {
        return this.bones;
    }

    @Nullable
    public String cape() {
        return this.cape;
    }

    @Nullable
    public ModelProperties modelProperties() {
        return this.modelProperties;
    }
}

