/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class LocatorClass {
    @Nullable
    private final Boolean ignoreInheritedScale;
    private final double[] offset;
    private final double[] rotation;

    public LocatorClass(@Nullable Boolean ignoreInheritedScale, double[] offset, double[] rotation) {
        this.ignoreInheritedScale = ignoreInheritedScale;
        this.offset = offset;
        this.rotation = rotation;
    }

    public static JsonDeserializer<LocatorClass> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Boolean ignoreInheritedScale = JsonUtil.getOptionalBoolean(obj, "ignore_inherited_scale");
            double[] offset = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "offset", null));
            double[] rotation = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "rotation", null));
            return new LocatorClass(ignoreInheritedScale, offset, rotation);
        };
    }

    @Nullable
    public Boolean ignoreInheritedScale() {
        return this.ignoreInheritedScale;
    }

    public double[] offset() {
        return this.offset;
    }

    public double[] rotation() {
        return this.rotation;
    }
}

