/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class FaceUV {
    @Nullable
    private final String materialInstance;
    private final double[] uv;
    private final double[] uvSize;

    public FaceUV(@Nullable String materialInstance, double[] uv, double[] uvSize) {
        this.materialInstance = materialInstance;
        this.uv = uv;
        this.uvSize = uvSize;
    }

    public static JsonDeserializer<FaceUV> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            String materialInstance = GsonHelper.getAsString(obj, "material_instance", null);
            double[] uv = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "uv", null));
            double[] uvSize = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "uv_size", null));
            return new FaceUV(materialInstance, uv, uvSize);
        };
    }

    @Nullable
    public String materialInstance() {
        return this.materialInstance;
    }

    public double[] uv() {
        return this.uv;
    }

    public double[] uvSize() {
        return this.uvSize;
    }
}

