/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import software.bernie.geckolib.forge.loading.json.raw.UVUnion;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class Cube {
    @Nullable
    private final Double inflate;
    @Nullable
    private final Boolean mirror;
    private final double[] origin;
    private final double[] pivot;
    private final double[] rotation;
    private final double[] size;
    private final UVUnion uv;

    public Cube(@Nullable Double inflate, @Nullable Boolean mirror, double[] origin, double[] pivot, double[] rotation, double[] size, UVUnion uv) {
        this.inflate = inflate;
        this.mirror = mirror;
        this.origin = origin;
        this.pivot = pivot;
        this.rotation = rotation;
        this.size = size;
        this.uv = uv;
    }

    public static JsonDeserializer<Cube> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Double inflate = JsonUtil.getOptionalDouble(obj, "inflate");
            Boolean mirror = JsonUtil.getOptionalBoolean(obj, "mirror");
            double[] origin = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "origin", null));
            double[] pivot = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "pivot", null));
            double[] rotation = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "rotation", null));
            double[] size = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "size", null));
            UVUnion uvUnion = GsonHelper.getAsObject(obj, "uv", null, context, UVUnion.class);
            return new Cube(inflate, mirror, origin, pivot, rotation, size, uvUnion);
        };
    }

    @Nullable
    public Double inflate() {
        return this.inflate;
    }

    @Nullable
    public Boolean mirror() {
        return this.mirror;
    }

    public double[] origin() {
        return this.origin;
    }

    public double[] pivot() {
        return this.pivot;
    }

    public double[] rotation() {
        return this.rotation;
    }

    public double[] size() {
        return this.size;
    }

    public UVUnion uv() {
        return this.uv;
    }
}

