/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading.json.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import javax.annotation.Nullable;
import software.bernie.geckolib.forge.loading.json.raw.Cube;
import software.bernie.geckolib.forge.loading.json.raw.LocatorValue;
import software.bernie.geckolib.forge.loading.json.raw.PolyMesh;
import software.bernie.geckolib.forge.loading.json.raw.TextureMesh;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;

public class Bone {
    private final double[] bindPoseRotation;
    private final Cube[] cubes;
    @Nullable
    private final Boolean debug;
    @Nullable
    private final Double inflate;
    @Nullable
    private final Map<String, LocatorValue> locators;
    @Nullable
    private final Boolean mirror;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean neverRender;
    @Nullable
    private final String parent;
    private final double[] pivot;
    @Nullable
    private final PolyMesh polyMesh;
    @Nullable
    private final Long renderGroupId;
    @Nullable
    private final Boolean reset;
    private final double[] rotation;
    @Nullable
    private final TextureMesh[] textureMeshes;

    public Bone(double[] bindPoseRotation, Cube[] cubes, @Nullable Boolean debug, @Nullable Double inflate, @Nullable Map<String, LocatorValue> locators, @Nullable Boolean mirror, @Nullable String name, @Nullable Boolean neverRender, @Nullable String parent, double[] pivot, @Nullable PolyMesh polyMesh, @Nullable Long renderGroupId, @Nullable Boolean reset, double[] rotation, @Nullable TextureMesh[] textureMeshes) {
        this.bindPoseRotation = bindPoseRotation;
        this.cubes = cubes;
        this.debug = debug;
        this.inflate = inflate;
        this.locators = locators;
        this.mirror = mirror;
        this.name = name;
        this.neverRender = neverRender;
        this.parent = parent;
        this.pivot = pivot;
        this.polyMesh = polyMesh;
        this.renderGroupId = renderGroupId;
        this.reset = reset;
        this.rotation = rotation;
        this.textureMeshes = textureMeshes;
    }

    public static JsonDeserializer<Bone> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            double[] bindPoseRotation = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "bind_pose_rotation", null));
            Cube[] cubes = JsonUtil.jsonArrayToObjectArray(GsonHelper.getAsJsonArray(obj, "cubes", new JsonArray()), context, Cube.class);
            Boolean debug = JsonUtil.getOptionalBoolean(obj, "debug");
            Double inflate = JsonUtil.getOptionalDouble(obj, "inflate");
            Map<String, LocatorValue> locators = obj.has("locators") ? JsonUtil.jsonObjToMap(GsonHelper.getAsJsonObject(obj, "locators"), context, LocatorValue.class) : null;
            Boolean mirror = JsonUtil.getOptionalBoolean(obj, "mirror");
            String name = GsonHelper.getAsString(obj, "name", null);
            Boolean neverRender = JsonUtil.getOptionalBoolean(obj, "neverRender");
            String parent = GsonHelper.getAsString(obj, "parent", null);
            double[] pivot = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "pivot", new JsonArray()));
            PolyMesh polyMesh = GsonHelper.getAsObject(obj, "poly_mesh", null, context, PolyMesh.class);
            Long renderGroupId = JsonUtil.getOptionalLong(obj, "render_group_id");
            Boolean reset = JsonUtil.getOptionalBoolean(obj, "reset");
            double[] rotation = JsonUtil.jsonArrayToDoubleArray(GsonHelper.getAsJsonArray(obj, "rotation", null));
            TextureMesh[] textureMeshes = JsonUtil.jsonArrayToObjectArray(GsonHelper.getAsJsonArray(obj, "texture_meshes", new JsonArray()), context, TextureMesh.class);
            return new Bone(bindPoseRotation, cubes, debug, inflate, locators, mirror, name, neverRender, parent, pivot, polyMesh, renderGroupId, reset, rotation, textureMeshes);
        };
    }

    public double[] bindPoseRotation() {
        return this.bindPoseRotation;
    }

    public Cube[] cubes() {
        return this.cubes;
    }

    @Nullable
    public Boolean debug() {
        return this.debug;
    }

    @Nullable
    public Double inflate() {
        return this.inflate;
    }

    @Nullable
    public Map<String, LocatorValue> locators() {
        return this.locators;
    }

    @Nullable
    public Boolean mirror() {
        return this.mirror;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Boolean neverRender() {
        return this.neverRender;
    }

    @Nullable
    public String parent() {
        return this.parent;
    }

    public double[] pivot() {
        return this.pivot;
    }

    @Nullable
    public PolyMesh polyMesh() {
        return this.polyMesh;
    }

    @Nullable
    public Long renderGroupId() {
        return this.renderGroupId;
    }

    @Nullable
    public Boolean reset() {
        return this.reset;
    }

    public double[] rotation() {
        return this.rotation;
    }

    @Nullable
    public TextureMesh[] textureMeshes() {
        return this.textureMeshes;
    }
}

