/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.loading;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import software.bernie.geckolib.forge.GeckoLib;
import software.bernie.geckolib.forge.loading.json.raw.Model;
import software.bernie.geckolib.forge.loading.object.BakedAnimations;
import software.bernie.geckolib.forge.util.GsonHelper;
import software.bernie.geckolib.forge.util.JsonUtil;
import software.bernie.geckolib.forge.util.mc.ItemTransforms;

public final class FileLoader {
    public static BakedAnimations loadAnimationsFile(ResourceLocation location, IResourceManager manager) {
        return (BakedAnimations)JsonUtil.GEO_GSON.fromJson((JsonElement)GsonHelper.getAsJsonObject(FileLoader.loadFile(location, manager), "animations"), BakedAnimations.class);
    }

    public static Model loadModelFile(ResourceLocation location, IResourceManager manager) {
        return (Model)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), Model.class);
    }

    public static ItemTransforms loadTransformsFile(ResourceLocation location, IResourceManager manager) {
        return (ItemTransforms)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), ItemTransforms.class);
    }

    public static JsonObject loadFile(ResourceLocation location, IResourceManager manager) {
        return GsonHelper.fromJson(JsonUtil.GEO_GSON, FileLoader.getFileContents(location, manager), JsonObject.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContents(ResourceLocation location, IResourceManager manager) {
        try (InputStream inputStream = manager.func_110536_a(location).func_110527_b();){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            return string;
        }
        catch (Exception e) {
            GeckoLib.LOGGER.error("Couldn't load " + location, (Throwable)e);
            throw new RuntimeException(new FileNotFoundException(location.toString()));
        }
    }
}

