/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.constant;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.forge.GeckoLib;
import software.bernie.geckolib.forge.model.data.EntityModelData;
import software.bernie.geckolib.forge.network.SerializableDataTicket;
import software.bernie.geckolib.forge.util.GeckoLibUtil;
import software.bernie.geckolib.forge.util.mc.ItemDisplayContext;

public class DataTickets {
    public static final DataTicket<Double> TICK = new DataTicket<Double>("tick", Double.class);
    public static final DataTicket<TileEntity> BLOCK_ENTITY = new DataTicket<TileEntity>("tile_entity", TileEntity.class);
    public static final DataTicket<ItemStack> ITEMSTACK = new DataTicket<ItemStack>("itemstack", ItemStack.class);
    public static final DataTicket<Entity> ENTITY = new DataTicket<Entity>("entity", Entity.class);
    public static final DataTicket<EntityModelData> ENTITY_MODEL_DATA = new DataTicket<EntityModelData>("entity_model_data", EntityModelData.class);
    public static final DataTicket<ItemDisplayContext> ITEM_RENDER_PERSPECTIVE = new DataTicket<ItemDisplayContext>("item_render_perspective", ItemDisplayContext.class);
    public static final SerializableDataTicket<Integer> ANIM_STATE = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofInt(new ResourceLocation("geckolib", "anim_state")));
    public static final SerializableDataTicket<String> ANIM = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofString(new ResourceLocation("geckolib", "anim")));
    public static final SerializableDataTicket<Integer> USE_TICKS = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofInt(new ResourceLocation("geckolib", "use_ticks")));
    public static final SerializableDataTicket<Boolean> ACTIVE = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("geckolib", "active")));
    public static final SerializableDataTicket<Boolean> OPEN = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("geckolib", "open")));
    public static final SerializableDataTicket<Boolean> CLOSED = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofBoolean(new ResourceLocation("geckolib", "closed")));
    public static final SerializableDataTicket<EnumFacing> DIRECTION = GeckoLibUtil.addDataTicket(SerializableDataTicket.ofEnum(new ResourceLocation("geckolib", "direction"), EnumFacing.class));
    private static Map<String, SerializableDataTicket<?>> SERIALIZABLE_TICKETS = new ConcurrentHashMap();

    @Nullable
    public static SerializableDataTicket<?> byName(String id) {
        return SERIALIZABLE_TICKETS.getOrDefault(id, null);
    }

    public static <D> SerializableDataTicket<D> registerSerializable(SerializableDataTicket<D> ticket) {
        SerializableDataTicket<D> existingTicket;
        if (SERIALIZABLE_TICKETS == null) {
            SERIALIZABLE_TICKETS = new ConcurrentHashMap();
        }
        if ((existingTicket = SERIALIZABLE_TICKETS.putIfAbsent(ticket.id(), ticket)) != null) {
            GeckoLib.LOGGER.error("Duplicate SerializableDataTicket registered! This will cause issues. Existing: " + existingTicket.id() + ", New: " + ticket.id());
        }
        return ticket;
    }
}

