/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.cache.texture;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.forge.util.ModTextureUtil;
import software.bernie.geckolib.forge.util.NativeImage;

public abstract class GeoAbstractTexture
extends AbstractTexture {
    protected static void generateTexture(ResourceLocation texturePath, Consumer<TextureManager> textureManagerConsumer) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (!(textureManager.func_110581_b(texturePath) instanceof GeoAbstractTexture)) {
            textureManagerConsumer.accept(textureManager);
        }
    }

    public final void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.loadTexture(resourceManager, Minecraft.func_71410_x());
    }

    protected void printDebugImageToDisk(ResourceLocation id, NativeImage newImage) {
        try {
            File file = new File(Minecraft.func_71410_x().field_71412_D, "GeoTexture Debug Printouts");
            if (!file.exists()) {
                file.mkdirs();
            } else if (!file.isDirectory()) {
                file.delete();
                file.mkdirs();
            }
            file = new File(file, id.func_110623_a().replace('/', '.'));
            if (!file.exists()) {
                file.createNewFile();
            }
            newImage.writeToFile(file.toPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Nullable
    protected abstract void loadTexture(IResourceManager var1, Minecraft var2) throws IOException;

    public static void uploadSimple(int texture, NativeImage image, boolean blur, boolean clamp) {
        ModTextureUtil.prepareImage(texture, 0, image.getWidth(), image.getHeight());
        image.upload(0, 0, 0, 0, 0, image.getWidth(), image.getHeight(), blur, clamp, false, true);
    }

    public static ResourceLocation appendToPath(ResourceLocation location, String suffix) {
        String path = location.func_110623_a();
        int i = path.lastIndexOf(46);
        return new ResourceLocation(location.func_110624_b(), path.substring(0, i) + suffix + path.substring(i));
    }
}

