/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.cache.texture;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib.forge.GeckoLib;
import software.bernie.geckolib.forge.cache.texture.AnimatableTexture;
import software.bernie.geckolib.forge.cache.texture.GeoAbstractTexture;
import software.bernie.geckolib.forge.resource.GeoGlowingTextureMeta;
import software.bernie.geckolib.forge.util.NativeImage;

public class AutoGlowingTexture
extends GeoAbstractTexture {
    private static final String APPENDIX = "_glowmask";
    protected final ResourceLocation textureBase;
    protected final ResourceLocation glowLayer;

    public AutoGlowingTexture(ResourceLocation originalLocation, ResourceLocation location) {
        this.textureBase = originalLocation;
        this.glowLayer = location;
    }

    public static ResourceLocation getEmissiveResource(ResourceLocation baseResource) {
        ResourceLocation path = AutoGlowingTexture.appendToPath(baseResource, APPENDIX);
        AutoGlowingTexture.generateTexture(path, textureManager -> textureManager.func_110579_a(path, (ITextureObject)new AutoGlowingTexture(baseResource, path)));
        return path;
    }

    @Override
    protected void loadTexture(IResourceManager resourceManager, Minecraft mc) throws IOException {
        AbstractTexture originalTexture = (AbstractTexture)mc.func_110434_K().func_110581_b(this.textureBase);
        if (originalTexture == null) {
            AnimatableTexture animatableTexture = new AnimatableTexture(this.textureBase);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(this.textureBase, (ITextureObject)animatableTexture);
            if (!animatableTexture.isAnimated()) {
                originalTexture = new SimpleTexture(this.textureBase);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(this.textureBase, (ITextureObject)originalTexture);
            }
        }
        IResource textureBaseResource = resourceManager.func_110536_a(this.textureBase);
        NativeImage baseImage = NativeImage.read(textureBaseResource.func_110527_b());
        NativeImage glowImage = null;
        TextureMetadataSection textureBaseMeta = (TextureMetadataSection)textureBaseResource.func_110526_a("texture");
        boolean blur = textureBaseMeta != null && textureBaseMeta.func_110479_a();
        boolean clamp = textureBaseMeta != null && textureBaseMeta.func_110480_b();
        try {
            GeoGlowingTextureMeta glowLayerMeta = null;
            try {
                IResource glowLayerResource = resourceManager.func_110536_a(this.glowLayer);
                glowImage = NativeImage.read(glowLayerResource.func_110527_b());
                glowLayerMeta = GeoGlowingTextureMeta.fromExistingImage(glowImage);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (glowLayerMeta != null) {
                glowLayerMeta.createImageMask(baseImage, glowImage);
                this.printDebugImageToDisk(this.textureBase, baseImage);
                this.printDebugImageToDisk(this.glowLayer, glowImage);
            }
        }
        catch (IOException e) {
            GeckoLib.LOGGER.warn("Resource failed to open for glowlayer meta: {}", new Object[]{this.glowLayer, e});
        }
        NativeImage mask = glowImage;
        if (mask == null) {
            return;
        }
        AutoGlowingTexture.uploadSimple(this.func_110552_b(), mask, blur, clamp);
        if (originalTexture instanceof DynamicTexture) {
            ((DynamicTexture)originalTexture).func_110564_a();
        } else {
            AutoGlowingTexture.uploadSimple(originalTexture.func_110552_b(), baseImage, blur, clamp);
        }
    }

    public static BufferedImage recreateBufferedImage(int[] dynamicTextureData, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] imagePixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        System.arraycopy(dynamicTextureData, 0, imagePixels, 0, dynamicTextureData.length);
        return image;
    }
}

