/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.cache.texture;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import software.bernie.geckolib.forge.GeckoLib;
import software.bernie.geckolib.forge.util.FrameSize;
import software.bernie.geckolib.forge.util.ModTextureUtil;
import software.bernie.geckolib.forge.util.NativeImage;
import software.bernie.geckolib.forge.util.RenderUtil;
import software.bernie.geckolib.forge.util.mc.MathUtil;

public class AnimatableTexture
extends SimpleTexture {
    private AnimationContents animationContents = null;
    private boolean isAnimated = false;

    public AnimatableTexture(ResourceLocation location) {
        super(location);
    }

    public void func_110551_a(IResourceManager manager) throws IOException {
        IResource resource = manager.func_110536_a(this.field_110568_b);
        try {
            NativeImage nativeImage;
            try (InputStream inputstream = resource.func_110527_b();){
                nativeImage = NativeImage.read(inputstream);
            }
            AnimationMetadataSection animationMetadataSection = (AnimationMetadataSection)resource.func_110526_a("animation");
            AnimationContents animationContents = this.animationContents = animationMetadataSection != null ? new AnimationContents(nativeImage, animationMetadataSection) : null;
            if (this.animationContents != null) {
                if (!this.animationContents.isValid()) {
                    nativeImage.close();
                    return;
                }
                this.isAnimated = true;
                ModTextureUtil.prepareImage(this.func_110552_b(), 0, this.animationContents.frameSize.width(), this.animationContents.frameSize.height());
                nativeImage.upload(0, 0, 0, 0, 0, this.animationContents.frameSize.width(), this.animationContents.frameSize.height(), false, false);
            }
        }
        catch (RuntimeException exception) {
            GeckoLib.LOGGER.warn("Failed reading metadata of: {}", new Object[]{this.field_110568_b, exception});
        }
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public static void setAndUpdate(ResourceLocation texturePath) {
        AnimatableTexture.setAndUpdate(texturePath, (int)RenderUtil.getCurrentTick());
    }

    public static void setAndUpdate(ResourceLocation texturePath, int frameTick) {
        ITextureObject texture = Minecraft.func_71410_x().func_110434_K().func_110581_b(texturePath);
        if (texture instanceof AnimatableTexture) {
            AnimatableTexture animatableTexture = (AnimatableTexture)texture;
            animatableTexture.setAnimationFrame(frameTick);
            AnimatableTexture.setShaderTexture(0, texture.func_110552_b());
        }
    }

    public static void setShaderTexture(int textureUnit, int textureId) {
        if (textureUnit < 0 || textureUnit >= 34018) {
            throw new IllegalArgumentException("Invalid texture unit: " + textureUnit);
        }
        GL13.glActiveTexture((int)(33984 + textureUnit));
        GL11.glBindTexture((int)3553, (int)textureId);
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    private class AnimationContents {
        private final FrameSize frameSize;
        private final Texture animatedTexture;

        private AnimationContents(NativeImage image, AnimationMetadataSection animMeta) {
            this.frameSize = this.calculateFrameSize(animMeta, image.getWidth(), image.getHeight());
            this.animatedTexture = this.generateAnimatedTexture(image, animMeta);
        }

        public FrameSize calculateFrameSize(AnimationMetadataSection animMeta, int pWidth, int pHeight) {
            if (animMeta.func_110474_b() != -1) {
                return animMeta.func_110471_a() != -1 ? new FrameSize(animMeta.func_110474_b(), animMeta.func_110471_a()) : new FrameSize(animMeta.func_110474_b(), pHeight);
            }
            if (animMeta.func_110471_a() != -1) {
                return new FrameSize(pWidth, animMeta.func_110471_a());
            }
            int size = Math.min(pWidth, pHeight);
            return new FrameSize(size, size);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        private Texture generateAnimatedTexture(NativeImage image, AnimationMetadataSection animMeta) {
            if (!MathUtil.isMultipleOf(image.getWidth(), this.frameSize.width()) || !MathUtil.isMultipleOf(image.getHeight(), this.frameSize.height())) {
                GeckoLib.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{AnimatableTexture.this.field_110568_b, image.getWidth(), image.getHeight(), this.frameSize.width(), this.frameSize.height()});
                return null;
            }
            int columns = image.getWidth() / this.frameSize.width();
            int rows = image.getHeight() / this.frameSize.height();
            int frameCount = columns * rows;
            ObjectArrayList frames = new ObjectArrayList();
            for (int i = 0; i < animMeta.func_110473_c(); ++i) {
                AnimationFrame animationFrame = (AnimationFrame)animMeta.field_110478_a.get(i);
                int time = animationFrame.func_110497_b() == -1 ? 1 : animationFrame.func_110497_b();
                frames.add(new Frame(animationFrame.func_110496_c(), time));
            }
            if (frames.isEmpty()) {
                for (int frame = 0; frame < frameCount; ++frame) {
                    frames.add(new Frame(frame, animMeta.func_110469_d()));
                }
            } else {
                int index = 0;
                IntOpenHashSet unusedFrames = new IntOpenHashSet();
                for (Frame frame : frames) {
                    if (frame.time <= 0L) {
                        GeckoLib.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{AnimatableTexture.this.field_110568_b, index, frame.time});
                        unusedFrames.add(frame.index);
                    } else if (frame.index < 0 || frame.index >= frameCount) {
                        GeckoLib.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{AnimatableTexture.this.field_110568_b, index, frame.index});
                        unusedFrames.add(frame.index);
                    }
                    ++index;
                }
                if (!unusedFrames.isEmpty()) {
                    GeckoLib.LOGGER.warn("Unused frames in sprite {}: {}", new Object[]{AnimatableTexture.this.field_110568_b, Arrays.toString(unusedFrames.toArray())});
                }
            }
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray((T[])new Frame[0]), columns, false);
        }

        private class Texture
        implements AutoCloseable {
            private final NativeImage baseImage;
            private final Frame[] frames;
            private final int framePanelSize;
            private final boolean interpolating;
            private final NativeImage interpolatedFrame;
            private final int totalFrameTime;
            private int currentFrame;
            private int currentSubframe;

            private Texture(NativeImage baseImage, Frame[] frames, int framePanelSize, boolean interpolating) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new NativeImage(AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false) : null;
                int time = 0;
                for (Frame frame : this.frames) {
                    time = (int)((long)time + frame.time);
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            private int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time = (int)((long)time + frame.time))) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = (int)((long)ticks % frame.time);
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    ModTextureUtil.prepareImage(AnimatableTexture.this.func_110552_b(), 0, AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height());
                    this.baseImage.upload(0, 0, 0, this.getFrameX(this.currentFrame) * AnimationContents.this.frameSize.width(), this.getFrameY(this.currentFrame) * AnimationContents.this.frameSize.height(), AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false, false);
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    this.generateInterpolatedFrame();
                }
            }

            private void generateInterpolatedFrame() {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time;
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < this.interpolatedFrame.getHeight(); ++y) {
                        for (int x = 0; x < this.interpolatedFrame.getWidth(); ++x) {
                            int prevFramePixel = this.getPixel(frame.index, x, y);
                            int nextFramePixel = this.getPixel(nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            this.interpolatedFrame.setPixelRGBA(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    ModTextureUtil.prepareImage(AnimatableTexture.this.func_110552_b(), 0, AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height());
                    this.interpolatedFrame.upload(0, 0, 0, 0, 0, AnimationContents.this.frameSize.width(), AnimationContents.this.frameSize.height(), false, false);
                }
            }

            private int getPixel(int frameIndex, int x, int y) {
                return this.baseImage.getPixelRGBA(x + this.getFrameX(frameIndex) * AnimationContents.this.frameSize.width(), y + this.getFrameY(frameIndex) * AnimationContents.this.frameSize.height());
            }

            private int interpolate(double frameProgress, double prevColour, double nextColour) {
                return (int)(frameProgress * prevColour + (1.0 - frameProgress) * nextColour);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
            }
        }

        private class Frame {
            public final int index;
            public final long time;

            public Frame(int index, int time) {
                this.index = index;
                this.time = time;
            }
        }
    }
}

