/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.cache.object;

import net.minecraft.util.EnumFacing;
import software.bernie.geckolib.forge.cache.object.GeoVertex;
import software.bernie.libs.joml.Vector3f;

public class GeoQuad {
    private final GeoVertex[] vertices;
    private final Vector3f normal;
    private final EnumFacing direction;

    public GeoQuad(GeoVertex[] vertices, Vector3f normal, EnumFacing direction) {
        this.vertices = vertices;
        this.normal = normal;
        this.direction = direction;
    }

    public static GeoQuad build(GeoVertex[] vertices, double[] uvCoords, double[] uvSize, float texWidth, float texHeight, boolean mirror, EnumFacing direction) {
        return GeoQuad.build(vertices, (float)uvCoords[0], (float)uvCoords[1], (float)uvSize[0], (float)uvSize[1], texWidth, texHeight, mirror, direction);
    }

    public static GeoQuad build(GeoVertex[] vertices, float u, float v, float uSize, float vSize, float texWidth, float texHeight, boolean mirror, EnumFacing direction) {
        float uWidth = (u + uSize) / texWidth;
        float vHeight = (v + vSize) / texHeight;
        u /= texWidth;
        v /= texHeight;
        Vector3f normal = new Vector3f(direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
        if (!mirror) {
            float tempWidth = uWidth;
            uWidth = u;
            u = tempWidth;
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        vertices[0] = vertices[0].withUVs(u, v);
        vertices[1] = vertices[1].withUVs(uWidth, v);
        vertices[2] = vertices[2].withUVs(uWidth, vHeight);
        vertices[3] = vertices[3].withUVs(u, vHeight);
        return new GeoQuad(vertices, normal, direction);
    }

    public GeoVertex[] vertices() {
        return this.vertices;
    }

    public Vector3f normal() {
        return this.normal;
    }

    public EnumFacing direction() {
        return this.direction;
    }
}

