/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.animatable;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.forge.network.GeckoLibNetwork;
import software.bernie.geckolib.forge.network.SerializableDataTicket;
import software.bernie.geckolib.forge.network.packet.AnimDataSyncPacket;
import software.bernie.geckolib.forge.network.packet.AnimTriggerPacket;

public interface SingletonGeoAnimatable
extends GeoAnimatable {
    public static void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeckoLibNetwork.registerSyncedAnimatable(animatable);
    }

    @Nullable
    default public <D> D getAnimData(long instanceId, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(instanceId).getData(dataTicket);
    }

    default public <D> void setAnimData(Entity relatedEntity, long instanceId, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.field_70170_p.field_72995_K) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).setData(dataTicket, data);
        } else {
            this.syncAnimData(instanceId, dataTicket, data, relatedEntity);
        }
    }

    default public <D> void syncAnimData(long instanceId, SerializableDataTicket<D> dataTicket, D data, Entity relatedEntity) {
        GeckoLibNetwork.send(new AnimDataSyncPacket<D>(this.getSyncableId(), instanceId, dataTicket, data), relatedEntity);
    }

    default public <D> void triggerAnim(Entity relatedEntity, long instanceId, @Nullable String controllerName, String animName) {
        if (relatedEntity.field_70170_p.field_72995_K) {
            this.getAnimatableInstanceCache().getManagerForId(instanceId).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.send(new AnimTriggerPacket(this.getSyncableId(), instanceId, controllerName, animName), relatedEntity);
        }
    }

    default public <D> void triggerAnim(long instanceId, @Nullable String controllerName, String animName, Entity relatedEntity) {
        GeckoLibNetwork.send(new AnimTriggerPacket(this.getSyncableId(), instanceId, controllerName, animName), relatedEntity);
    }

    @Override
    @Nullable
    default public AnimatableInstanceCache animatableCacheOverride() {
        return new SingletonAnimatableInstanceCache(this);
    }
}

