/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.animatable;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.ContextAwareAnimatableManager;
import software.bernie.geckolib.core.object.DataTicket;
import software.bernie.geckolib.forge.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.forge.util.GeckoLibUtil;
import software.bernie.geckolib.forge.util.RenderUtil;
import software.bernie.geckolib.forge.util.mc.ItemDisplayContext;

public interface GeoItem
extends SingletonGeoAnimatable {
    public static final String ID_NBT_KEY = "GeckoLibID";

    public static long getId(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return Long.MAX_VALUE;
        }
        return tag.func_74763_f(ID_NBT_KEY);
    }

    @Deprecated
    public static long getOrAssignId(ItemStack stack, WorldServer level) {
        return GeoItem.getOrAssignId(stack);
    }

    public static long getOrAssignId(ItemStack stack) {
        NBTTagCompound tag = GeoItem.getOrCreateTag(stack);
        long id = tag.func_74763_f(ID_NBT_KEY);
        if (tag.func_150297_b(ID_NBT_KEY, 4)) {
            return id;
        }
        while ((id = GeckoLibUtil.SECURE_RANDOM.nextLong()) == 0L) {
        }
        tag.func_74772_a(ID_NBT_KEY, id);
        return id;
    }

    @Override
    default public double getTick(Object itemStack) {
        return RenderUtil.getCurrentTick();
    }

    default public boolean isPerspectiveAware() {
        return false;
    }

    @Override
    default public AnimatableInstanceCache animatableCacheOverride() {
        if (this.isPerspectiveAware()) {
            return new ContextBasedAnimatableInstanceCache(this);
        }
        return SingletonGeoAnimatable.super.animatableCacheOverride();
    }

    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    public static class ContextBasedAnimatableInstanceCache
    extends SingletonAnimatableInstanceCache {
        public ContextBasedAnimatableInstanceCache(GeoAnimatable animatable) {
            super(animatable);
        }

        @Override
        public AnimatableManager<?> getManagerForId(long uniqueId) {
            if (!this.managers.containsKey(uniqueId)) {
                this.managers.put(uniqueId, new ContextAwareAnimatableManager<GeoItem, ItemDisplayContext>(this.animatable){

                    @Override
                    protected Map<ItemDisplayContext, AnimatableManager<GeoItem>> buildContextOptions(GeoAnimatable animatable) {
                        EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>> map = new EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>>(ItemDisplayContext.class);
                        for (ItemDisplayContext context : ItemDisplayContext.values()) {
                            map.put(context, new AnimatableManager(animatable));
                        }
                        return map;
                    }

                    @Override
                    public ItemDisplayContext getCurrentContext() {
                        ItemDisplayContext context = this.getData(DataTicket.ITEM_RENDER_PERSPECTIVE);
                        return context == null ? ItemDisplayContext.NONE : context;
                    }
                });
            }
            return (AnimatableManager)this.managers.get(uniqueId);
        }
    }
}

