/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.forge.animatable;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.forge.GeckoLib;
import software.bernie.geckolib.forge.network.GeckoLibNetwork;
import software.bernie.geckolib.forge.network.SerializableDataTicket;
import software.bernie.geckolib.forge.network.packet.BlockEntityAnimDataSyncPacket;
import software.bernie.geckolib.forge.network.packet.BlockEntityAnimTriggerPacket;
import software.bernie.geckolib.forge.util.RenderUtil;

public interface GeoBlockEntity
extends GeoAnimatable {
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(0L).getData(dataTicket);
    }

    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        TileEntity blockEntity = (TileEntity)this;
        World level = blockEntity.func_145831_w();
        if (level == null) {
            GeckoLib.LOGGER.error("Attempting to set animation data for BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass().toString() + ")");
            return;
        }
        if (level.field_72995_K) {
            this.getAnimatableInstanceCache().getManagerForId(0L).setData(dataTicket, data);
        } else {
            GeckoLibNetwork.send(new BlockEntityAnimDataSyncPacket<D>(blockEntity.field_145851_c, blockEntity.field_145848_d, blockEntity.field_145849_e, dataTicket, data), level, blockEntity.field_145851_c, blockEntity.field_145848_d, blockEntity.field_145849_e, 20);
        }
    }

    default public void triggerAnim(@Nullable String controllerName, String animName) {
        TileEntity blockEntity = (TileEntity)this;
        World level = blockEntity.func_145831_w();
        if (level == null) {
            GeckoLib.LOGGER.error("Attempting to trigger an animation for a BlockEntity too early! Must wait until after the BlockEntity has been set in the world. (" + blockEntity.getClass() + ")");
            return;
        }
        if (level.field_72995_K) {
            this.getAnimatableInstanceCache().getManagerForId(0L).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibNetwork.send(new BlockEntityAnimTriggerPacket(blockEntity.field_145851_c, blockEntity.field_145848_d, blockEntity.field_145849_e, controllerName, animName), level, blockEntity.field_145851_c, blockEntity.field_145848_d, blockEntity.field_145849_e, 20);
        }
    }

    @Override
    default public double getTick(Object blockEntity) {
        return RenderUtil.getCurrentTick();
    }
}

