/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.core.keyframe;

import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.keyframe.AnimationPoint;
import software.bernie.geckolib.core.keyframe.AnimationPointQueue;
import software.bernie.geckolib.core.keyframe.Keyframe;
import software.bernie.geckolib.core.state.BoneSnapshot;

public class BoneAnimationQueue {
    private final CoreGeoBone bone;
    private final AnimationPointQueue rotationXQueue;
    private final AnimationPointQueue rotationYQueue;
    private final AnimationPointQueue rotationZQueue;
    private final AnimationPointQueue positionXQueue;
    private final AnimationPointQueue positionYQueue;
    private final AnimationPointQueue positionZQueue;
    private final AnimationPointQueue scaleXQueue;
    private final AnimationPointQueue scaleYQueue;
    private final AnimationPointQueue scaleZQueue;

    public BoneAnimationQueue(CoreGeoBone bone, AnimationPointQueue rotationXQueue, AnimationPointQueue rotationYQueue, AnimationPointQueue rotationZQueue, AnimationPointQueue positionXQueue, AnimationPointQueue positionYQueue, AnimationPointQueue positionZQueue, AnimationPointQueue scaleXQueue, AnimationPointQueue scaleYQueue, AnimationPointQueue scaleZQueue) {
        this.bone = bone;
        this.rotationXQueue = rotationXQueue;
        this.rotationYQueue = rotationYQueue;
        this.rotationZQueue = rotationZQueue;
        this.positionXQueue = positionXQueue;
        this.positionYQueue = positionYQueue;
        this.positionZQueue = positionZQueue;
        this.scaleXQueue = scaleXQueue;
        this.scaleYQueue = scaleYQueue;
        this.scaleZQueue = scaleZQueue;
    }

    public BoneAnimationQueue(CoreGeoBone bone) {
        this(bone, new AnimationPointQueue(), new AnimationPointQueue(), new AnimationPointQueue(), new AnimationPointQueue(), new AnimationPointQueue(), new AnimationPointQueue(), new AnimationPointQueue(), new AnimationPointQueue(), new AnimationPointQueue());
    }

    public void addPosXPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.positionXQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addPosYPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.positionYQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addPosZPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.positionZQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addNextPosition(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, BoneSnapshot startSnapshot, AnimationPoint nextXPoint, AnimationPoint nextYPoint, AnimationPoint nextZPoint) {
        this.addPosXPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getOffsetX(), nextXPoint.animationStartValue());
        this.addPosYPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getOffsetY(), nextYPoint.animationStartValue());
        this.addPosZPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getOffsetZ(), nextZPoint.animationStartValue());
    }

    public void addScaleXPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.scaleXQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addScaleYPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.scaleYQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addScaleZPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.scaleZQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addNextScale(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, BoneSnapshot startSnapshot, AnimationPoint nextXPoint, AnimationPoint nextYPoint, AnimationPoint nextZPoint) {
        this.addScaleXPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getScaleX(), nextXPoint.animationStartValue());
        this.addScaleYPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getScaleY(), nextYPoint.animationStartValue());
        this.addScaleZPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getScaleZ(), nextZPoint.animationStartValue());
    }

    public void addRotationXPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.rotationXQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addRotationYPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.rotationYQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addRotationZPoint(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, double startValue, double endValue) {
        this.rotationZQueue.add(new AnimationPoint(keyFrame, lerpedTick, transitionLength, startValue, endValue));
    }

    public void addNextRotation(Keyframe<?> keyFrame, double lerpedTick, double transitionLength, BoneSnapshot startSnapshot, BoneSnapshot initialSnapshot, AnimationPoint nextXPoint, AnimationPoint nextYPoint, AnimationPoint nextZPoint) {
        this.addRotationXPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getRotX() - initialSnapshot.getRotX(), nextXPoint.animationStartValue());
        this.addRotationYPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getRotY() - initialSnapshot.getRotY(), nextYPoint.animationStartValue());
        this.addRotationZPoint(keyFrame, lerpedTick, transitionLength, startSnapshot.getRotZ() - initialSnapshot.getRotZ(), nextZPoint.animationStartValue());
    }

    public void addPositions(AnimationPoint xPoint, AnimationPoint yPoint, AnimationPoint zPoint) {
        this.positionXQueue.add(xPoint);
        this.positionYQueue.add(yPoint);
        this.positionZQueue.add(zPoint);
    }

    public void addScales(AnimationPoint xPoint, AnimationPoint yPoint, AnimationPoint zPoint) {
        this.scaleXQueue.add(xPoint);
        this.scaleYQueue.add(yPoint);
        this.scaleZQueue.add(zPoint);
    }

    public void addRotations(AnimationPoint xPoint, AnimationPoint yPoint, AnimationPoint zPoint) {
        this.rotationXQueue.add(xPoint);
        this.rotationYQueue.add(yPoint);
        this.rotationZQueue.add(zPoint);
    }

    public CoreGeoBone bone() {
        return this.bone;
    }

    public AnimationPointQueue rotationXQueue() {
        return this.rotationXQueue;
    }

    public AnimationPointQueue rotationYQueue() {
        return this.rotationYQueue;
    }

    public AnimationPointQueue rotationZQueue() {
        return this.rotationZQueue;
    }

    public AnimationPointQueue positionXQueue() {
        return this.positionXQueue;
    }

    public AnimationPointQueue positionYQueue() {
        return this.positionYQueue;
    }

    public AnimationPointQueue positionZQueue() {
        return this.positionZQueue;
    }

    public AnimationPointQueue scaleXQueue() {
        return this.scaleXQueue;
    }

    public AnimationPointQueue scaleYQueue() {
        return this.scaleYQueue;
    }

    public AnimationPointQueue scaleZQueue() {
        return this.scaleZQueue;
    }
}

