/*
 * Decompiled with CFR 0.152.
 */
package loliland.lolidecorative.models.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileSynchronized
extends TileEntity {
    private ForgeDirection orientation = ForgeDirection.WEST;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCustomNBT(compound);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        this.orientation = ForgeDirection.values()[compound.func_74762_e("orientation")];
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.writeCustomNBT(compound);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        compound.func_74768_a("orientation", this.orientation.ordinal());
    }

    public final Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeCustomNBT(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 255, compound);
    }

    public final void onDataPacket(NetworkManager manager, S35PacketUpdateTileEntity paket) {
        super.onDataPacket(manager, paket);
        this.readCustomNBT(paket.func_148857_g());
    }

    public final void markDispatchable() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public final void markDirtyDispatchable() {
        this.func_70296_d();
        this.markDispatchable();
    }

    public void rotateAfterPlacement(EntityPlayer player, int side) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.setOrientation(ForgeDirection.NORTH);
        }
        if (l == 1) {
            this.setOrientation(ForgeDirection.EAST);
        }
        if (l == 2) {
            this.setOrientation(ForgeDirection.SOUTH);
        }
        if (l == 3) {
            this.setOrientation(ForgeDirection.WEST);
        }
    }

    public boolean rotate(ForgeDirection axis) {
        if (axis != ForgeDirection.DOWN && axis != ForgeDirection.UP) {
            return false;
        }
        ForgeDirection orientation = this.getOrientation().getRotation(axis);
        this.setOrientation(orientation);
        return true;
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        if (orientation == null) {
            throw new NullPointerException("Orientation cannot be null");
        }
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.func_70296_d();
            this.markDispatchable();
        }
    }
}

